/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.paymentcryptographydata.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.paymentcryptographydata.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * DukptEncryptionAttributesMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class DukptEncryptionAttributesMarshaller {

    private static final MarshallingInfo<String> KEYSERIALNUMBER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeySerialNumber").build();
    private static final MarshallingInfo<String> MODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Mode").build();
    private static final MarshallingInfo<String> DUKPTKEYDERIVATIONTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DukptKeyDerivationType").build();
    private static final MarshallingInfo<String> DUKPTKEYVARIANT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DukptKeyVariant").build();
    private static final MarshallingInfo<String> INITIALIZATIONVECTOR_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InitializationVector").build();

    private static final DukptEncryptionAttributesMarshaller instance = new DukptEncryptionAttributesMarshaller();

    public static DukptEncryptionAttributesMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(DukptEncryptionAttributes dukptEncryptionAttributes, ProtocolMarshaller protocolMarshaller) {

        if (dukptEncryptionAttributes == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(dukptEncryptionAttributes.getKeySerialNumber(), KEYSERIALNUMBER_BINDING);
            protocolMarshaller.marshall(dukptEncryptionAttributes.getMode(), MODE_BINDING);
            protocolMarshaller.marshall(dukptEncryptionAttributes.getDukptKeyDerivationType(), DUKPTKEYDERIVATIONTYPE_BINDING);
            protocolMarshaller.marshall(dukptEncryptionAttributes.getDukptKeyVariant(), DUKPTKEYVARIANT_BINDING);
            protocolMarshaller.marshall(dukptEncryptionAttributes.getInitializationVector(), INITIALIZATIONVECTOR_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
