/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptography.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.paymentcryptography.model.ExportKeyCryptogram;
import com.amazonaws.services.paymentcryptography.model.ExportTr31KeyBlock;
import com.amazonaws.services.paymentcryptography.model.ExportTr34KeyBlock;
import com.amazonaws.services.paymentcryptography.model.transform.ExportKeyMaterialMarshaller;
import java.io.Serializable;

public class ExportKeyMaterial
implements Serializable,
Cloneable,
StructuredPojo {
    private ExportTr31KeyBlock tr31KeyBlock;
    private ExportTr34KeyBlock tr34KeyBlock;
    private ExportKeyCryptogram keyCryptogram;

    public void setTr31KeyBlock(ExportTr31KeyBlock tr31KeyBlock) {
        this.tr31KeyBlock = tr31KeyBlock;
    }

    public ExportTr31KeyBlock getTr31KeyBlock() {
        return this.tr31KeyBlock;
    }

    public ExportKeyMaterial withTr31KeyBlock(ExportTr31KeyBlock tr31KeyBlock) {
        this.setTr31KeyBlock(tr31KeyBlock);
        return this;
    }

    public void setTr34KeyBlock(ExportTr34KeyBlock tr34KeyBlock) {
        this.tr34KeyBlock = tr34KeyBlock;
    }

    public ExportTr34KeyBlock getTr34KeyBlock() {
        return this.tr34KeyBlock;
    }

    public ExportKeyMaterial withTr34KeyBlock(ExportTr34KeyBlock tr34KeyBlock) {
        this.setTr34KeyBlock(tr34KeyBlock);
        return this;
    }

    public void setKeyCryptogram(ExportKeyCryptogram keyCryptogram) {
        this.keyCryptogram = keyCryptogram;
    }

    public ExportKeyCryptogram getKeyCryptogram() {
        return this.keyCryptogram;
    }

    public ExportKeyMaterial withKeyCryptogram(ExportKeyCryptogram keyCryptogram) {
        this.setKeyCryptogram(keyCryptogram);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTr31KeyBlock() != null) {
            sb.append("Tr31KeyBlock: ").append(this.getTr31KeyBlock()).append(",");
        }
        if (this.getTr34KeyBlock() != null) {
            sb.append("Tr34KeyBlock: ").append(this.getTr34KeyBlock()).append(",");
        }
        if (this.getKeyCryptogram() != null) {
            sb.append("KeyCryptogram: ").append(this.getKeyCryptogram());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportKeyMaterial)) {
            return false;
        }
        ExportKeyMaterial other = (ExportKeyMaterial)obj;
        if (other.getTr31KeyBlock() == null ^ this.getTr31KeyBlock() == null) {
            return false;
        }
        if (other.getTr31KeyBlock() != null && !other.getTr31KeyBlock().equals(this.getTr31KeyBlock())) {
            return false;
        }
        if (other.getTr34KeyBlock() == null ^ this.getTr34KeyBlock() == null) {
            return false;
        }
        if (other.getTr34KeyBlock() != null && !other.getTr34KeyBlock().equals(this.getTr34KeyBlock())) {
            return false;
        }
        if (other.getKeyCryptogram() == null ^ this.getKeyCryptogram() == null) {
            return false;
        }
        return other.getKeyCryptogram() == null || other.getKeyCryptogram().equals(this.getKeyCryptogram());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTr31KeyBlock() == null ? 0 : this.getTr31KeyBlock().hashCode());
        hashCode = 31 * hashCode + (this.getTr34KeyBlock() == null ? 0 : this.getTr34KeyBlock().hashCode());
        hashCode = 31 * hashCode + (this.getKeyCryptogram() == null ? 0 : this.getKeyCryptogram().hashCode());
        return hashCode;
    }

    public ExportKeyMaterial clone() {
        try {
            return (ExportKeyMaterial)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExportKeyMaterialMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

