/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptography;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.paymentcryptography.AWSPaymentCryptography;
import com.amazonaws.services.paymentcryptography.AWSPaymentCryptographyClientBuilder;
import com.amazonaws.services.paymentcryptography.model.AWSPaymentCryptographyException;
import com.amazonaws.services.paymentcryptography.model.CreateAliasRequest;
import com.amazonaws.services.paymentcryptography.model.CreateAliasResult;
import com.amazonaws.services.paymentcryptography.model.CreateKeyRequest;
import com.amazonaws.services.paymentcryptography.model.CreateKeyResult;
import com.amazonaws.services.paymentcryptography.model.DeleteAliasRequest;
import com.amazonaws.services.paymentcryptography.model.DeleteAliasResult;
import com.amazonaws.services.paymentcryptography.model.DeleteKeyRequest;
import com.amazonaws.services.paymentcryptography.model.DeleteKeyResult;
import com.amazonaws.services.paymentcryptography.model.ExportKeyRequest;
import com.amazonaws.services.paymentcryptography.model.ExportKeyResult;
import com.amazonaws.services.paymentcryptography.model.GetAliasRequest;
import com.amazonaws.services.paymentcryptography.model.GetAliasResult;
import com.amazonaws.services.paymentcryptography.model.GetKeyRequest;
import com.amazonaws.services.paymentcryptography.model.GetKeyResult;
import com.amazonaws.services.paymentcryptography.model.GetParametersForExportRequest;
import com.amazonaws.services.paymentcryptography.model.GetParametersForExportResult;
import com.amazonaws.services.paymentcryptography.model.GetParametersForImportRequest;
import com.amazonaws.services.paymentcryptography.model.GetParametersForImportResult;
import com.amazonaws.services.paymentcryptography.model.GetPublicKeyCertificateRequest;
import com.amazonaws.services.paymentcryptography.model.GetPublicKeyCertificateResult;
import com.amazonaws.services.paymentcryptography.model.ImportKeyRequest;
import com.amazonaws.services.paymentcryptography.model.ImportKeyResult;
import com.amazonaws.services.paymentcryptography.model.ListAliasesRequest;
import com.amazonaws.services.paymentcryptography.model.ListAliasesResult;
import com.amazonaws.services.paymentcryptography.model.ListKeysRequest;
import com.amazonaws.services.paymentcryptography.model.ListKeysResult;
import com.amazonaws.services.paymentcryptography.model.ListTagsForResourceRequest;
import com.amazonaws.services.paymentcryptography.model.ListTagsForResourceResult;
import com.amazonaws.services.paymentcryptography.model.RestoreKeyRequest;
import com.amazonaws.services.paymentcryptography.model.RestoreKeyResult;
import com.amazonaws.services.paymentcryptography.model.StartKeyUsageRequest;
import com.amazonaws.services.paymentcryptography.model.StartKeyUsageResult;
import com.amazonaws.services.paymentcryptography.model.StopKeyUsageRequest;
import com.amazonaws.services.paymentcryptography.model.StopKeyUsageResult;
import com.amazonaws.services.paymentcryptography.model.TagResourceRequest;
import com.amazonaws.services.paymentcryptography.model.TagResourceResult;
import com.amazonaws.services.paymentcryptography.model.UntagResourceRequest;
import com.amazonaws.services.paymentcryptography.model.UntagResourceResult;
import com.amazonaws.services.paymentcryptography.model.UpdateAliasRequest;
import com.amazonaws.services.paymentcryptography.model.UpdateAliasResult;
import com.amazonaws.services.paymentcryptography.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.CreateAliasRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.CreateAliasResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.CreateKeyRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.CreateKeyResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.DeleteAliasRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.DeleteAliasResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.DeleteKeyRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.DeleteKeyResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.ExportKeyRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.ExportKeyResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.GetAliasRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.GetAliasResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.GetKeyRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.GetKeyResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.GetParametersForExportRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.GetParametersForExportResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.GetParametersForImportRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.GetParametersForImportResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.GetPublicKeyCertificateRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.GetPublicKeyCertificateResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.ImportKeyRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.ImportKeyResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.ListAliasesRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.ListAliasesResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.ListKeysRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.ListKeysResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.RestoreKeyRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.RestoreKeyResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.ServiceUnavailableExceptionUnmarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.StartKeyUsageRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.StartKeyUsageResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.StopKeyUsageRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.StopKeyUsageResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.UpdateAliasRequestProtocolMarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.UpdateAliasResultJsonUnmarshaller;
import com.amazonaws.services.paymentcryptography.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSPaymentCryptographyClient
extends AmazonWebServiceClient
implements AWSPaymentCryptography {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSPaymentCryptography.class);
    private static final String DEFAULT_SIGNING_NAME = "payment-cryptography";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.0").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceUnavailableExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSPaymentCryptographyException.class));

    public static AWSPaymentCryptographyClientBuilder builder() {
        return AWSPaymentCryptographyClientBuilder.standard();
    }

    AWSPaymentCryptographyClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSPaymentCryptographyClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("controlplane.payment-cryptography");
        this.setEndpoint("controlplane.payment-cryptography.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/paymentcryptography/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/paymentcryptography/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateAliasResult createAlias(CreateAliasRequest request) {
        request = (CreateAliasRequest)this.beforeClientExecution(request);
        return this.executeCreateAlias(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateAliasResult executeCreateAlias(CreateAliasRequest createAliasRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAliasRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAliasRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAliasRequestProtocolMarshaller(protocolFactory).marshall((CreateAliasRequest)super.beforeMarshalling((AmazonWebServiceRequest)createAliasRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateAlias");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateAliasResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateAliasResult createAliasResult = (CreateAliasResult)response.getAwsResponse();
            return createAliasResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateKeyResult createKey(CreateKeyRequest request) {
        request = (CreateKeyRequest)this.beforeClientExecution(request);
        return this.executeCreateKey(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateKeyResult executeCreateKey(CreateKeyRequest createKeyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createKeyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateKeyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateKeyRequestProtocolMarshaller(protocolFactory).marshall((CreateKeyRequest)super.beforeMarshalling((AmazonWebServiceRequest)createKeyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateKey");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateKeyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateKeyResult createKeyResult = (CreateKeyResult)response.getAwsResponse();
            return createKeyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAliasResult deleteAlias(DeleteAliasRequest request) {
        request = (DeleteAliasRequest)this.beforeClientExecution(request);
        return this.executeDeleteAlias(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAliasResult executeDeleteAlias(DeleteAliasRequest deleteAliasRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAliasRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAliasRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAliasRequestProtocolMarshaller(protocolFactory).marshall((DeleteAliasRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAliasRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteAlias");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAliasResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAliasResult deleteAliasResult = (DeleteAliasResult)response.getAwsResponse();
            return deleteAliasResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteKeyResult deleteKey(DeleteKeyRequest request) {
        request = (DeleteKeyRequest)this.beforeClientExecution(request);
        return this.executeDeleteKey(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteKeyResult executeDeleteKey(DeleteKeyRequest deleteKeyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteKeyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteKeyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteKeyRequestProtocolMarshaller(protocolFactory).marshall((DeleteKeyRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteKeyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteKey");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteKeyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteKeyResult deleteKeyResult = (DeleteKeyResult)response.getAwsResponse();
            return deleteKeyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ExportKeyResult exportKey(ExportKeyRequest request) {
        request = (ExportKeyRequest)this.beforeClientExecution(request);
        return this.executeExportKey(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ExportKeyResult executeExportKey(ExportKeyRequest exportKeyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(exportKeyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ExportKeyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ExportKeyRequestProtocolMarshaller(protocolFactory).marshall((ExportKeyRequest)super.beforeMarshalling((AmazonWebServiceRequest)exportKeyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ExportKey");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ExportKeyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ExportKeyResult exportKeyResult = (ExportKeyResult)response.getAwsResponse();
            return exportKeyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAliasResult getAlias(GetAliasRequest request) {
        request = (GetAliasRequest)this.beforeClientExecution(request);
        return this.executeGetAlias(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAliasResult executeGetAlias(GetAliasRequest getAliasRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAliasRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAliasRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAliasRequestProtocolMarshaller(protocolFactory).marshall((GetAliasRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAliasRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAlias");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAliasResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAliasResult getAliasResult = (GetAliasResult)response.getAwsResponse();
            return getAliasResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetKeyResult getKey(GetKeyRequest request) {
        request = (GetKeyRequest)this.beforeClientExecution(request);
        return this.executeGetKey(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetKeyResult executeGetKey(GetKeyRequest getKeyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getKeyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetKeyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetKeyRequestProtocolMarshaller(protocolFactory).marshall((GetKeyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getKeyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetKey");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetKeyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetKeyResult getKeyResult = (GetKeyResult)response.getAwsResponse();
            return getKeyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetParametersForExportResult getParametersForExport(GetParametersForExportRequest request) {
        request = (GetParametersForExportRequest)this.beforeClientExecution(request);
        return this.executeGetParametersForExport(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetParametersForExportResult executeGetParametersForExport(GetParametersForExportRequest getParametersForExportRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getParametersForExportRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetParametersForExportRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetParametersForExportRequestProtocolMarshaller(protocolFactory).marshall((GetParametersForExportRequest)super.beforeMarshalling((AmazonWebServiceRequest)getParametersForExportRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetParametersForExport");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetParametersForExportResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetParametersForExportResult getParametersForExportResult = (GetParametersForExportResult)response.getAwsResponse();
            return getParametersForExportResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetParametersForImportResult getParametersForImport(GetParametersForImportRequest request) {
        request = (GetParametersForImportRequest)this.beforeClientExecution(request);
        return this.executeGetParametersForImport(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetParametersForImportResult executeGetParametersForImport(GetParametersForImportRequest getParametersForImportRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getParametersForImportRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetParametersForImportRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetParametersForImportRequestProtocolMarshaller(protocolFactory).marshall((GetParametersForImportRequest)super.beforeMarshalling((AmazonWebServiceRequest)getParametersForImportRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetParametersForImport");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetParametersForImportResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetParametersForImportResult getParametersForImportResult = (GetParametersForImportResult)response.getAwsResponse();
            return getParametersForImportResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetPublicKeyCertificateResult getPublicKeyCertificate(GetPublicKeyCertificateRequest request) {
        request = (GetPublicKeyCertificateRequest)this.beforeClientExecution(request);
        return this.executeGetPublicKeyCertificate(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetPublicKeyCertificateResult executeGetPublicKeyCertificate(GetPublicKeyCertificateRequest getPublicKeyCertificateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPublicKeyCertificateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPublicKeyCertificateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPublicKeyCertificateRequestProtocolMarshaller(protocolFactory).marshall((GetPublicKeyCertificateRequest)super.beforeMarshalling((AmazonWebServiceRequest)getPublicKeyCertificateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetPublicKeyCertificate");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetPublicKeyCertificateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetPublicKeyCertificateResult getPublicKeyCertificateResult = (GetPublicKeyCertificateResult)response.getAwsResponse();
            return getPublicKeyCertificateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ImportKeyResult importKey(ImportKeyRequest request) {
        request = (ImportKeyRequest)this.beforeClientExecution(request);
        return this.executeImportKey(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ImportKeyResult executeImportKey(ImportKeyRequest importKeyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(importKeyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ImportKeyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ImportKeyRequestProtocolMarshaller(protocolFactory).marshall((ImportKeyRequest)super.beforeMarshalling((AmazonWebServiceRequest)importKeyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ImportKey");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ImportKeyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ImportKeyResult importKeyResult = (ImportKeyResult)response.getAwsResponse();
            return importKeyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAliasesResult listAliases(ListAliasesRequest request) {
        request = (ListAliasesRequest)this.beforeClientExecution(request);
        return this.executeListAliases(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAliasesResult executeListAliases(ListAliasesRequest listAliasesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAliasesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAliasesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAliasesRequestProtocolMarshaller(protocolFactory).marshall((ListAliasesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAliasesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAliases");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAliasesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAliasesResult listAliasesResult = (ListAliasesResult)response.getAwsResponse();
            return listAliasesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListKeysResult listKeys(ListKeysRequest request) {
        request = (ListKeysRequest)this.beforeClientExecution(request);
        return this.executeListKeys(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListKeysResult executeListKeys(ListKeysRequest listKeysRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listKeysRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListKeysRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListKeysRequestProtocolMarshaller(protocolFactory).marshall((ListKeysRequest)super.beforeMarshalling((AmazonWebServiceRequest)listKeysRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListKeys");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListKeysResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListKeysResult listKeysResult = (ListKeysResult)response.getAwsResponse();
            return listKeysResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RestoreKeyResult restoreKey(RestoreKeyRequest request) {
        request = (RestoreKeyRequest)this.beforeClientExecution(request);
        return this.executeRestoreKey(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RestoreKeyResult executeRestoreKey(RestoreKeyRequest restoreKeyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(restoreKeyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RestoreKeyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RestoreKeyRequestProtocolMarshaller(protocolFactory).marshall((RestoreKeyRequest)super.beforeMarshalling((AmazonWebServiceRequest)restoreKeyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RestoreKey");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RestoreKeyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RestoreKeyResult restoreKeyResult = (RestoreKeyResult)response.getAwsResponse();
            return restoreKeyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartKeyUsageResult startKeyUsage(StartKeyUsageRequest request) {
        request = (StartKeyUsageRequest)this.beforeClientExecution(request);
        return this.executeStartKeyUsage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartKeyUsageResult executeStartKeyUsage(StartKeyUsageRequest startKeyUsageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startKeyUsageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartKeyUsageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartKeyUsageRequestProtocolMarshaller(protocolFactory).marshall((StartKeyUsageRequest)super.beforeMarshalling((AmazonWebServiceRequest)startKeyUsageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartKeyUsage");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartKeyUsageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartKeyUsageResult startKeyUsageResult = (StartKeyUsageResult)response.getAwsResponse();
            return startKeyUsageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopKeyUsageResult stopKeyUsage(StopKeyUsageRequest request) {
        request = (StopKeyUsageRequest)this.beforeClientExecution(request);
        return this.executeStopKeyUsage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopKeyUsageResult executeStopKeyUsage(StopKeyUsageRequest stopKeyUsageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopKeyUsageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopKeyUsageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopKeyUsageRequestProtocolMarshaller(protocolFactory).marshall((StopKeyUsageRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopKeyUsageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopKeyUsage");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopKeyUsageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopKeyUsageResult stopKeyUsageResult = (StopKeyUsageResult)response.getAwsResponse();
            return stopKeyUsageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateAliasResult updateAlias(UpdateAliasRequest request) {
        request = (UpdateAliasRequest)this.beforeClientExecution(request);
        return this.executeUpdateAlias(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateAliasResult executeUpdateAlias(UpdateAliasRequest updateAliasRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAliasRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateAliasRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateAliasRequestProtocolMarshaller(protocolFactory).marshall((UpdateAliasRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateAliasRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Payment Cryptography");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateAlias");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateAliasResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateAliasResult updateAliasResult = (UpdateAliasResult)response.getAwsResponse();
            return updateAliasResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

