/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptography.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.paymentcryptography.model.KeyAttributes;
import com.amazonaws.services.paymentcryptography.model.WrappingKeySpec;
import com.amazonaws.services.paymentcryptography.model.transform.ImportKeyCryptogramMarshaller;
import java.io.Serializable;

public class ImportKeyCryptogram
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean exportable;
    private String importToken;
    private KeyAttributes keyAttributes;
    private String wrappedKeyCryptogram;
    private String wrappingSpec;

    public void setExportable(Boolean exportable) {
        this.exportable = exportable;
    }

    public Boolean getExportable() {
        return this.exportable;
    }

    public ImportKeyCryptogram withExportable(Boolean exportable) {
        this.setExportable(exportable);
        return this;
    }

    public Boolean isExportable() {
        return this.exportable;
    }

    public void setImportToken(String importToken) {
        this.importToken = importToken;
    }

    public String getImportToken() {
        return this.importToken;
    }

    public ImportKeyCryptogram withImportToken(String importToken) {
        this.setImportToken(importToken);
        return this;
    }

    public void setKeyAttributes(KeyAttributes keyAttributes) {
        this.keyAttributes = keyAttributes;
    }

    public KeyAttributes getKeyAttributes() {
        return this.keyAttributes;
    }

    public ImportKeyCryptogram withKeyAttributes(KeyAttributes keyAttributes) {
        this.setKeyAttributes(keyAttributes);
        return this;
    }

    public void setWrappedKeyCryptogram(String wrappedKeyCryptogram) {
        this.wrappedKeyCryptogram = wrappedKeyCryptogram;
    }

    public String getWrappedKeyCryptogram() {
        return this.wrappedKeyCryptogram;
    }

    public ImportKeyCryptogram withWrappedKeyCryptogram(String wrappedKeyCryptogram) {
        this.setWrappedKeyCryptogram(wrappedKeyCryptogram);
        return this;
    }

    public void setWrappingSpec(String wrappingSpec) {
        this.wrappingSpec = wrappingSpec;
    }

    public String getWrappingSpec() {
        return this.wrappingSpec;
    }

    public ImportKeyCryptogram withWrappingSpec(String wrappingSpec) {
        this.setWrappingSpec(wrappingSpec);
        return this;
    }

    public ImportKeyCryptogram withWrappingSpec(WrappingKeySpec wrappingSpec) {
        this.wrappingSpec = wrappingSpec.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getExportable() != null) {
            sb.append("Exportable: ").append(this.getExportable()).append(",");
        }
        if (this.getImportToken() != null) {
            sb.append("ImportToken: ").append(this.getImportToken()).append(",");
        }
        if (this.getKeyAttributes() != null) {
            sb.append("KeyAttributes: ").append(this.getKeyAttributes()).append(",");
        }
        if (this.getWrappedKeyCryptogram() != null) {
            sb.append("WrappedKeyCryptogram: ").append(this.getWrappedKeyCryptogram()).append(",");
        }
        if (this.getWrappingSpec() != null) {
            sb.append("WrappingSpec: ").append(this.getWrappingSpec());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportKeyCryptogram)) {
            return false;
        }
        ImportKeyCryptogram other = (ImportKeyCryptogram)obj;
        if (other.getExportable() == null ^ this.getExportable() == null) {
            return false;
        }
        if (other.getExportable() != null && !other.getExportable().equals(this.getExportable())) {
            return false;
        }
        if (other.getImportToken() == null ^ this.getImportToken() == null) {
            return false;
        }
        if (other.getImportToken() != null && !other.getImportToken().equals(this.getImportToken())) {
            return false;
        }
        if (other.getKeyAttributes() == null ^ this.getKeyAttributes() == null) {
            return false;
        }
        if (other.getKeyAttributes() != null && !other.getKeyAttributes().equals(this.getKeyAttributes())) {
            return false;
        }
        if (other.getWrappedKeyCryptogram() == null ^ this.getWrappedKeyCryptogram() == null) {
            return false;
        }
        if (other.getWrappedKeyCryptogram() != null && !other.getWrappedKeyCryptogram().equals(this.getWrappedKeyCryptogram())) {
            return false;
        }
        if (other.getWrappingSpec() == null ^ this.getWrappingSpec() == null) {
            return false;
        }
        return other.getWrappingSpec() == null || other.getWrappingSpec().equals(this.getWrappingSpec());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getExportable() == null ? 0 : this.getExportable().hashCode());
        hashCode = 31 * hashCode + (this.getImportToken() == null ? 0 : this.getImportToken().hashCode());
        hashCode = 31 * hashCode + (this.getKeyAttributes() == null ? 0 : this.getKeyAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getWrappedKeyCryptogram() == null ? 0 : this.getWrappedKeyCryptogram().hashCode());
        hashCode = 31 * hashCode + (this.getWrappingSpec() == null ? 0 : this.getWrappingSpec().hashCode());
        return hashCode;
    }

    public ImportKeyCryptogram clone() {
        try {
            return (ImportKeyCryptogram)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImportKeyCryptogramMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

