/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.panorama.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.panorama.model.StorageLocation;

@SdkInternalApi
public class StorageLocationMarshaller {
    private static final MarshallingInfo<String> BUCKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Bucket").build();
    private static final MarshallingInfo<String> REPOPREFIXLOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RepoPrefixLocation").build();
    private static final MarshallingInfo<String> GENERATEDPREFIXLOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GeneratedPrefixLocation").build();
    private static final MarshallingInfo<String> BINARYPREFIXLOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BinaryPrefixLocation").build();
    private static final MarshallingInfo<String> MANIFESTPREFIXLOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ManifestPrefixLocation").build();
    private static final StorageLocationMarshaller instance = new StorageLocationMarshaller();

    public static StorageLocationMarshaller getInstance() {
        return instance;
    }

    public void marshall(StorageLocation storageLocation, ProtocolMarshaller protocolMarshaller) {
        if (storageLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)storageLocation.getBucket(), BUCKET_BINDING);
            protocolMarshaller.marshall((Object)storageLocation.getRepoPrefixLocation(), REPOPREFIXLOCATION_BINDING);
            protocolMarshaller.marshall((Object)storageLocation.getGeneratedPrefixLocation(), GENERATEDPREFIXLOCATION_BINDING);
            protocolMarshaller.marshall((Object)storageLocation.getBinaryPrefixLocation(), BINARYPREFIXLOCATION_BINDING);
            protocolMarshaller.marshall((Object)storageLocation.getManifestPrefixLocation(), MANIFESTPREFIXLOCATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

