/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.route53domains.AmazonRoute53Domains;
import com.amazonaws.services.route53domains.model.CheckDomainAvailabilityRequest;
import com.amazonaws.services.route53domains.model.CheckDomainAvailabilityResult;
import com.amazonaws.services.route53domains.model.DisableDomainAutoRenewRequest;
import com.amazonaws.services.route53domains.model.DisableDomainAutoRenewResult;
import com.amazonaws.services.route53domains.model.DisableDomainTransferLockRequest;
import com.amazonaws.services.route53domains.model.DisableDomainTransferLockResult;
import com.amazonaws.services.route53domains.model.EnableDomainAutoRenewRequest;
import com.amazonaws.services.route53domains.model.EnableDomainAutoRenewResult;
import com.amazonaws.services.route53domains.model.EnableDomainTransferLockRequest;
import com.amazonaws.services.route53domains.model.EnableDomainTransferLockResult;
import com.amazonaws.services.route53domains.model.GetDomainDetailRequest;
import com.amazonaws.services.route53domains.model.GetDomainDetailResult;
import com.amazonaws.services.route53domains.model.GetOperationDetailRequest;
import com.amazonaws.services.route53domains.model.GetOperationDetailResult;
import com.amazonaws.services.route53domains.model.ListDomainsRequest;
import com.amazonaws.services.route53domains.model.ListDomainsResult;
import com.amazonaws.services.route53domains.model.ListOperationsRequest;
import com.amazonaws.services.route53domains.model.ListOperationsResult;
import com.amazonaws.services.route53domains.model.RegisterDomainRequest;
import com.amazonaws.services.route53domains.model.RegisterDomainResult;
import com.amazonaws.services.route53domains.model.RetrieveDomainAuthCodeRequest;
import com.amazonaws.services.route53domains.model.RetrieveDomainAuthCodeResult;
import com.amazonaws.services.route53domains.model.TransferDomainRequest;
import com.amazonaws.services.route53domains.model.TransferDomainResult;
import com.amazonaws.services.route53domains.model.UpdateDomainContactPrivacyRequest;
import com.amazonaws.services.route53domains.model.UpdateDomainContactPrivacyResult;
import com.amazonaws.services.route53domains.model.UpdateDomainContactRequest;
import com.amazonaws.services.route53domains.model.UpdateDomainContactResult;
import com.amazonaws.services.route53domains.model.UpdateDomainNameserversRequest;
import com.amazonaws.services.route53domains.model.UpdateDomainNameserversResult;
import com.amazonaws.services.route53domains.model.transform.CheckDomainAvailabilityRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.CheckDomainAvailabilityResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.DisableDomainAutoRenewRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.DisableDomainAutoRenewResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.DisableDomainTransferLockRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.DisableDomainTransferLockResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.DomainLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.DuplicateRequestExceptionUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.EnableDomainAutoRenewRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.EnableDomainAutoRenewResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.EnableDomainTransferLockRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.EnableDomainTransferLockResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.GetDomainDetailRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.GetDomainDetailResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.GetOperationDetailRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.GetOperationDetailResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.InvalidInputExceptionUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.ListDomainsRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.ListDomainsResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.ListOperationsRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.ListOperationsResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.OperationLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.RegisterDomainRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.RegisterDomainResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.RetrieveDomainAuthCodeRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.RetrieveDomainAuthCodeResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.TLDRulesViolationExceptionUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.TransferDomainRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.TransferDomainResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.UnsupportedTLDExceptionUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.UpdateDomainContactPrivacyRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.UpdateDomainContactPrivacyResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.UpdateDomainContactRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.UpdateDomainContactResultJsonUnmarshaller;
import com.amazonaws.services.route53domains.model.transform.UpdateDomainNameserversRequestMarshaller;
import com.amazonaws.services.route53domains.model.transform.UpdateDomainNameserversResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AmazonRoute53DomainsClient
extends AmazonWebServiceClient
implements AmazonRoute53Domains {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonRoute53Domains.class);
    protected List<JsonErrorUnmarshaller> jsonErrorUnmarshallers;

    public AmazonRoute53DomainsClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonRoute53DomainsClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonRoute53DomainsClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonRoute53DomainsClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(AmazonRoute53DomainsClient.adjustClientConfiguration(clientConfiguration));
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonRoute53DomainsClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonRoute53DomainsClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonRoute53DomainsClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(AmazonRoute53DomainsClient.adjustClientConfiguration(clientConfiguration), requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();
        this.jsonErrorUnmarshallers.add(new DuplicateRequestExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new TLDRulesViolationExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidInputExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new DomainLimitExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new OperationLimitExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new UnsupportedTLDExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("route53domains.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/route53domains/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/route53domains/request.handler2s"));
    }

    private static ClientConfiguration adjustClientConfiguration(ClientConfiguration orig) {
        ClientConfiguration config = orig;
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDomainContactResult updateDomainContact(UpdateDomainContactRequest updateDomainContactRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDomainContactRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDomainContactRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDomainContactRequestMarshaller().marshall(updateDomainContactRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            UpdateDomainContactResultJsonUnmarshaller unmarshaller = new UpdateDomainContactResultJsonUnmarshaller();
            JsonResponseHandler<UpdateDomainContactResult> responseHandler = new JsonResponseHandler<UpdateDomainContactResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDomainContactResult updateDomainContactResult = (UpdateDomainContactResult)response.getAwsResponse();
            return updateDomainContactResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckDomainAvailabilityResult checkDomainAvailability(CheckDomainAvailabilityRequest checkDomainAvailabilityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(checkDomainAvailabilityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CheckDomainAvailabilityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CheckDomainAvailabilityRequestMarshaller().marshall(checkDomainAvailabilityRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CheckDomainAvailabilityResultJsonUnmarshaller unmarshaller = new CheckDomainAvailabilityResultJsonUnmarshaller();
            JsonResponseHandler<CheckDomainAvailabilityResult> responseHandler = new JsonResponseHandler<CheckDomainAvailabilityResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            CheckDomainAvailabilityResult checkDomainAvailabilityResult = (CheckDomainAvailabilityResult)response.getAwsResponse();
            return checkDomainAvailabilityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableDomainAutoRenewResult enableDomainAutoRenew(EnableDomainAutoRenewRequest enableDomainAutoRenewRequest) {
        ExecutionContext executionContext = this.createExecutionContext(enableDomainAutoRenewRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EnableDomainAutoRenewRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EnableDomainAutoRenewRequestMarshaller().marshall(enableDomainAutoRenewRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            EnableDomainAutoRenewResultJsonUnmarshaller unmarshaller = new EnableDomainAutoRenewResultJsonUnmarshaller();
            JsonResponseHandler<EnableDomainAutoRenewResult> responseHandler = new JsonResponseHandler<EnableDomainAutoRenewResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            EnableDomainAutoRenewResult enableDomainAutoRenewResult = (EnableDomainAutoRenewResult)response.getAwsResponse();
            return enableDomainAutoRenewResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListOperationsResult listOperations(ListOperationsRequest listOperationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listOperationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListOperationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListOperationsRequestMarshaller().marshall(listOperationsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListOperationsResultJsonUnmarshaller unmarshaller = new ListOperationsResultJsonUnmarshaller();
            JsonResponseHandler<ListOperationsResult> responseHandler = new JsonResponseHandler<ListOperationsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ListOperationsResult listOperationsResult = (ListOperationsResult)response.getAwsResponse();
            return listOperationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDomainsResult listDomains(ListDomainsRequest listDomainsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDomainsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDomainsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDomainsRequestMarshaller().marshall(listDomainsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListDomainsResultJsonUnmarshaller unmarshaller = new ListDomainsResultJsonUnmarshaller();
            JsonResponseHandler<ListDomainsResult> responseHandler = new JsonResponseHandler<ListDomainsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ListDomainsResult listDomainsResult = (ListDomainsResult)response.getAwsResponse();
            return listDomainsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetOperationDetailResult getOperationDetail(GetOperationDetailRequest getOperationDetailRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getOperationDetailRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetOperationDetailRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetOperationDetailRequestMarshaller().marshall(getOperationDetailRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetOperationDetailResultJsonUnmarshaller unmarshaller = new GetOperationDetailResultJsonUnmarshaller();
            JsonResponseHandler<GetOperationDetailResult> responseHandler = new JsonResponseHandler<GetOperationDetailResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            GetOperationDetailResult getOperationDetailResult = (GetOperationDetailResult)response.getAwsResponse();
            return getOperationDetailResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableDomainTransferLockResult disableDomainTransferLock(DisableDomainTransferLockRequest disableDomainTransferLockRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disableDomainTransferLockRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisableDomainTransferLockRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisableDomainTransferLockRequestMarshaller().marshall(disableDomainTransferLockRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DisableDomainTransferLockResultJsonUnmarshaller unmarshaller = new DisableDomainTransferLockResultJsonUnmarshaller();
            JsonResponseHandler<DisableDomainTransferLockResult> responseHandler = new JsonResponseHandler<DisableDomainTransferLockResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DisableDomainTransferLockResult disableDomainTransferLockResult = (DisableDomainTransferLockResult)response.getAwsResponse();
            return disableDomainTransferLockResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDomainNameserversResult updateDomainNameservers(UpdateDomainNameserversRequest updateDomainNameserversRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDomainNameserversRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDomainNameserversRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDomainNameserversRequestMarshaller().marshall(updateDomainNameserversRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            UpdateDomainNameserversResultJsonUnmarshaller unmarshaller = new UpdateDomainNameserversResultJsonUnmarshaller();
            JsonResponseHandler<UpdateDomainNameserversResult> responseHandler = new JsonResponseHandler<UpdateDomainNameserversResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDomainNameserversResult updateDomainNameserversResult = (UpdateDomainNameserversResult)response.getAwsResponse();
            return updateDomainNameserversResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableDomainTransferLockResult enableDomainTransferLock(EnableDomainTransferLockRequest enableDomainTransferLockRequest) {
        ExecutionContext executionContext = this.createExecutionContext(enableDomainTransferLockRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EnableDomainTransferLockRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EnableDomainTransferLockRequestMarshaller().marshall(enableDomainTransferLockRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            EnableDomainTransferLockResultJsonUnmarshaller unmarshaller = new EnableDomainTransferLockResultJsonUnmarshaller();
            JsonResponseHandler<EnableDomainTransferLockResult> responseHandler = new JsonResponseHandler<EnableDomainTransferLockResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            EnableDomainTransferLockResult enableDomainTransferLockResult = (EnableDomainTransferLockResult)response.getAwsResponse();
            return enableDomainTransferLockResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableDomainAutoRenewResult disableDomainAutoRenew(DisableDomainAutoRenewRequest disableDomainAutoRenewRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disableDomainAutoRenewRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisableDomainAutoRenewRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisableDomainAutoRenewRequestMarshaller().marshall(disableDomainAutoRenewRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DisableDomainAutoRenewResultJsonUnmarshaller unmarshaller = new DisableDomainAutoRenewResultJsonUnmarshaller();
            JsonResponseHandler<DisableDomainAutoRenewResult> responseHandler = new JsonResponseHandler<DisableDomainAutoRenewResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DisableDomainAutoRenewResult disableDomainAutoRenewResult = (DisableDomainAutoRenewResult)response.getAwsResponse();
            return disableDomainAutoRenewResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterDomainResult registerDomain(RegisterDomainRequest registerDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterDomainRequestMarshaller().marshall(registerDomainRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            RegisterDomainResultJsonUnmarshaller unmarshaller = new RegisterDomainResultJsonUnmarshaller();
            JsonResponseHandler<RegisterDomainResult> responseHandler = new JsonResponseHandler<RegisterDomainResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            RegisterDomainResult registerDomainResult = (RegisterDomainResult)response.getAwsResponse();
            return registerDomainResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDomainDetailResult getDomainDetail(GetDomainDetailRequest getDomainDetailRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDomainDetailRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDomainDetailRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDomainDetailRequestMarshaller().marshall(getDomainDetailRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetDomainDetailResultJsonUnmarshaller unmarshaller = new GetDomainDetailResultJsonUnmarshaller();
            JsonResponseHandler<GetDomainDetailResult> responseHandler = new JsonResponseHandler<GetDomainDetailResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            GetDomainDetailResult getDomainDetailResult = (GetDomainDetailResult)response.getAwsResponse();
            return getDomainDetailResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RetrieveDomainAuthCodeResult retrieveDomainAuthCode(RetrieveDomainAuthCodeRequest retrieveDomainAuthCodeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(retrieveDomainAuthCodeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RetrieveDomainAuthCodeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RetrieveDomainAuthCodeRequestMarshaller().marshall(retrieveDomainAuthCodeRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            RetrieveDomainAuthCodeResultJsonUnmarshaller unmarshaller = new RetrieveDomainAuthCodeResultJsonUnmarshaller();
            JsonResponseHandler<RetrieveDomainAuthCodeResult> responseHandler = new JsonResponseHandler<RetrieveDomainAuthCodeResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            RetrieveDomainAuthCodeResult retrieveDomainAuthCodeResult = (RetrieveDomainAuthCodeResult)response.getAwsResponse();
            return retrieveDomainAuthCodeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransferDomainResult transferDomain(TransferDomainRequest transferDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(transferDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TransferDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TransferDomainRequestMarshaller().marshall(transferDomainRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            TransferDomainResultJsonUnmarshaller unmarshaller = new TransferDomainResultJsonUnmarshaller();
            JsonResponseHandler<TransferDomainResult> responseHandler = new JsonResponseHandler<TransferDomainResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            TransferDomainResult transferDomainResult = (TransferDomainResult)response.getAwsResponse();
            return transferDomainResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDomainContactPrivacyResult updateDomainContactPrivacy(UpdateDomainContactPrivacyRequest updateDomainContactPrivacyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDomainContactPrivacyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDomainContactPrivacyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDomainContactPrivacyRequestMarshaller().marshall(updateDomainContactPrivacyRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            UpdateDomainContactPrivacyResultJsonUnmarshaller unmarshaller = new UpdateDomainContactPrivacyResultJsonUnmarshaller();
            JsonResponseHandler<UpdateDomainContactPrivacyResult> responseHandler = new JsonResponseHandler<UpdateDomainContactPrivacyResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDomainContactPrivacyResult updateDomainContactPrivacyResult = (UpdateDomainContactPrivacyResult)response.getAwsResponse();
            return updateDomainContactPrivacyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    @Override
    public ListOperationsResult listOperations() throws AmazonServiceException, AmazonClientException {
        return this.listOperations(new ListOperationsRequest());
    }

    @Override
    public ListDomainsResult listDomains() throws AmazonServiceException, AmazonClientException {
        return this.listDomains(new ListDomainsRequest());
    }

    @Override
    public void setEndpoint(String endpoint) {
        super.setEndpoint(endpoint);
    }

    @Override
    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        super.setEndpoint(endpoint, serviceName, regionId);
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.jsonErrorUnmarshallers);
        Response result = this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
        return result;
    }
}

