/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.cloudsearchv2.model.DescribeDomainsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeDomainsRequestMarshaller
implements Marshaller<Request<DescribeDomainsRequest>, DescribeDomainsRequest> {
    @Override
    public Request<DescribeDomainsRequest> marshall(DescribeDomainsRequest describeDomainsRequest) {
        if (describeDomainsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeDomainsRequest> request = new DefaultRequest<DescribeDomainsRequest>(describeDomainsRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DescribeDomains");
        request.addParameter("Version", "2013-01-01");
        List<String> domainNamesList = describeDomainsRequest.getDomainNames();
        int domainNamesListIndex = 1;
        for (String domainNamesListValue : domainNamesList) {
            if (domainNamesListValue != null) {
                request.addParameter("DomainNames.member." + domainNamesListIndex, StringUtils.fromString(domainNamesListValue));
            }
            ++domainNamesListIndex;
        }
        return request;
    }
}

