/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.internal.SdkFilterInputStream;
import com.amazonaws.services.s3.internal.crypto.CipherLite;
import com.amazonaws.services.s3.internal.crypto.S3CryptoScheme;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public class CipherLiteInputStream
extends SdkFilterInputStream {
    private static final int MAX_RETRY = 1000;
    private static final int DEFAULT_IN_BUFFER_SIZE = 512;
    private CipherLite cipherLite;
    private final boolean multipart;
    private boolean eof = false;
    private byte[] bufin;
    private byte[] bufout;
    private int curr_pos = 0;
    private int max_pos = 0;

    public CipherLiteInputStream(InputStream is, CipherLite cipherLite) {
        this(is, cipherLite, 512, false);
    }

    public CipherLiteInputStream(InputStream is, CipherLite c, int buffsize) {
        this(is, c, buffsize, false);
    }

    public CipherLiteInputStream(InputStream is, CipherLite c, int buffsize, boolean multipart) {
        super(is);
        this.multipart = multipart;
        this.cipherLite = c;
        if (buffsize <= 0 || buffsize % 512 != 0) {
            throw new IllegalArgumentException("buffsize (" + buffsize + ") must be a positive multiple of " + 512);
        }
        this.bufin = new byte[buffsize];
    }

    protected CipherLiteInputStream(InputStream is) {
        this(is, CipherLite.Null, 512, false);
    }

    @Override
    public int read() throws IOException {
        if (this.curr_pos >= this.max_pos) {
            int len;
            if (this.eof) {
                return -1;
            }
            int count = 0;
            do {
                if (count > 1000) {
                    throw new IOException("exceeded maximum number of attempts to read next chunk of data");
                }
                len = this.nextChunk();
                ++count;
            } while (len == 0);
            if (len == -1) {
                return -1;
            }
        }
        return this.bufout[this.curr_pos++] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] buf, int off, int target_len) throws IOException {
        if (this.curr_pos >= this.max_pos) {
            int len;
            if (this.eof) {
                return -1;
            }
            int count = 0;
            do {
                if (count > 1000) {
                    throw new IOException("exceeded maximum number of attempts to read next chunk of data");
                }
                len = this.nextChunk();
                ++count;
            } while (len == 0);
            if (len == -1) {
                return -1;
            }
        }
        if (target_len <= 0) {
            return 0;
        }
        int len = this.max_pos - this.curr_pos;
        if (target_len < len) {
            len = target_len;
        }
        System.arraycopy(this.bufout, this.curr_pos, buf, off, len);
        this.curr_pos += len;
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        this.abortIfNeeded();
        int available = this.max_pos - this.curr_pos;
        if (n > (long)available) {
            n = available;
        }
        if (n < 0L) {
            return 0L;
        }
        this.curr_pos = (int)((long)this.curr_pos + n);
        return n;
    }

    @Override
    public int available() {
        this.abortIfNeeded();
        return this.max_pos - this.curr_pos;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        if (!this.multipart && !S3CryptoScheme.isAesGcm(this.cipherLite.getCipherAlgorithm())) {
            try {
                this.cipherLite.doFinal();
            }
            catch (BadPaddingException ex) {
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                // empty catch block
            }
        }
        this.max_pos = 0;
        this.curr_pos = 0;
        this.abortIfNeeded();
    }

    @Override
    public boolean markSupported() {
        this.abortIfNeeded();
        return this.in.markSupported() && this.cipherLite.markSupported();
    }

    @Override
    public void mark(int readlimit) {
        this.abortIfNeeded();
        this.in.mark(readlimit);
        this.cipherLite.mark();
    }

    @Override
    public void reset() throws IOException {
        this.abortIfNeeded();
        this.in.reset();
        this.cipherLite.reset();
        this.resetInternal();
    }

    final void resetInternal() {
        this.max_pos = 0;
        this.curr_pos = 0;
        this.eof = false;
    }

    private int nextChunk() throws IOException {
        this.abortIfNeeded();
        if (this.eof) {
            return -1;
        }
        int len = this.in.read(this.bufin);
        if (len == -1) {
            block8: {
                this.eof = true;
                try {
                    this.bufout = this.cipherLite.doFinal();
                }
                catch (IllegalBlockSizeException ignore) {
                }
                catch (BadPaddingException e) {
                    if (!S3CryptoScheme.isAesGcm(this.cipherLite.getCipherAlgorithm())) break block8;
                    throw new SecurityException(e);
                }
            }
            if (this.bufout == null) {
                return -1;
            }
            this.curr_pos = 0;
            this.max_pos = this.bufout.length;
            return this.max_pos;
        }
        try {
            this.bufout = this.cipherLite.update(this.bufin, 0, len);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.curr_pos = 0;
        this.max_pos = this.bufout == null ? 0 : this.bufout.length;
        return this.max_pos;
    }

    void renewCipherLite() {
        this.cipherLite = this.cipherLite.recreate();
    }
}

