/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PendingModifiedValues
implements Serializable {
    private Integer numCacheNodes;
    private ListWithAutoConstructFlag<String> cacheNodeIdsToRemove;
    private String engineVersion;

    public Integer getNumCacheNodes() {
        return this.numCacheNodes;
    }

    public void setNumCacheNodes(Integer numCacheNodes) {
        this.numCacheNodes = numCacheNodes;
    }

    public PendingModifiedValues withNumCacheNodes(Integer numCacheNodes) {
        this.numCacheNodes = numCacheNodes;
        return this;
    }

    public List<String> getCacheNodeIdsToRemove() {
        if (this.cacheNodeIdsToRemove == null) {
            this.cacheNodeIdsToRemove = new ListWithAutoConstructFlag();
            this.cacheNodeIdsToRemove.setAutoConstruct(true);
        }
        return this.cacheNodeIdsToRemove;
    }

    public void setCacheNodeIdsToRemove(Collection<String> cacheNodeIdsToRemove) {
        if (cacheNodeIdsToRemove == null) {
            this.cacheNodeIdsToRemove = null;
            return;
        }
        ListWithAutoConstructFlag cacheNodeIdsToRemoveCopy = new ListWithAutoConstructFlag(cacheNodeIdsToRemove.size());
        cacheNodeIdsToRemoveCopy.addAll(cacheNodeIdsToRemove);
        this.cacheNodeIdsToRemove = cacheNodeIdsToRemoveCopy;
    }

    public PendingModifiedValues withCacheNodeIdsToRemove(String ... cacheNodeIdsToRemove) {
        if (this.getCacheNodeIdsToRemove() == null) {
            this.setCacheNodeIdsToRemove(new ArrayList<String>(cacheNodeIdsToRemove.length));
        }
        for (String value : cacheNodeIdsToRemove) {
            this.getCacheNodeIdsToRemove().add(value);
        }
        return this;
    }

    public PendingModifiedValues withCacheNodeIdsToRemove(Collection<String> cacheNodeIdsToRemove) {
        if (cacheNodeIdsToRemove == null) {
            this.cacheNodeIdsToRemove = null;
        } else {
            ListWithAutoConstructFlag cacheNodeIdsToRemoveCopy = new ListWithAutoConstructFlag(cacheNodeIdsToRemove.size());
            cacheNodeIdsToRemoveCopy.addAll(cacheNodeIdsToRemove);
            this.cacheNodeIdsToRemove = cacheNodeIdsToRemoveCopy;
        }
        return this;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public PendingModifiedValues withEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNumCacheNodes() != null) {
            sb.append("NumCacheNodes: " + this.getNumCacheNodes() + ",");
        }
        if (this.getCacheNodeIdsToRemove() != null) {
            sb.append("CacheNodeIdsToRemove: " + this.getCacheNodeIdsToRemove() + ",");
        }
        if (this.getEngineVersion() != null) {
            sb.append("EngineVersion: " + this.getEngineVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNumCacheNodes() == null ? 0 : this.getNumCacheNodes().hashCode());
        hashCode = 31 * hashCode + (this.getCacheNodeIdsToRemove() == null ? 0 : this.getCacheNodeIdsToRemove().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingModifiedValues)) {
            return false;
        }
        PendingModifiedValues other = (PendingModifiedValues)obj;
        if (other.getNumCacheNodes() == null ^ this.getNumCacheNodes() == null) {
            return false;
        }
        if (other.getNumCacheNodes() != null && !other.getNumCacheNodes().equals(this.getNumCacheNodes())) {
            return false;
        }
        if (other.getCacheNodeIdsToRemove() == null ^ this.getCacheNodeIdsToRemove() == null) {
            return false;
        }
        if (other.getCacheNodeIdsToRemove() != null && !other.getCacheNodeIdsToRemove().equals(this.getCacheNodeIdsToRemove())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        return other.getEngineVersion() == null || other.getEngineVersion().equals(this.getEngineVersion());
    }
}

