/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeImagesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeImagesRequestMarshaller
implements Marshaller<Request<DescribeImagesRequest>, DescribeImagesRequest> {
    @Override
    public Request<DescribeImagesRequest> marshall(DescribeImagesRequest describeImagesRequest) {
        if (describeImagesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeImagesRequest> request = new DefaultRequest<DescribeImagesRequest>(describeImagesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeImages");
        request.addParameter("Version", "2014-10-01");
        List<String> imageIdsList = describeImagesRequest.getImageIds();
        int imageIdsListIndex = 1;
        for (String imageIdsListValue : imageIdsList) {
            if (imageIdsListValue != null) {
                request.addParameter("ImageId." + imageIdsListIndex, StringUtils.fromString(imageIdsListValue));
            }
            ++imageIdsListIndex;
        }
        List<String> ownersList = describeImagesRequest.getOwners();
        int ownersListIndex = 1;
        for (String ownersListValue : ownersList) {
            if (ownersListValue != null) {
                request.addParameter("Owner." + ownersListIndex, StringUtils.fromString(ownersListValue));
            }
            ++ownersListIndex;
        }
        List<String> executableUsersList = describeImagesRequest.getExecutableUsers();
        int executableUsersListIndex = 1;
        for (String executableUsersListValue : executableUsersList) {
            if (executableUsersListValue != null) {
                request.addParameter("ExecutableBy." + executableUsersListIndex, StringUtils.fromString(executableUsersListValue));
            }
            ++executableUsersListIndex;
        }
        List<Filter> filtersList = describeImagesRequest.getFilters();
        int filtersListIndex = 1;
        for (Filter filtersListValue : filtersList) {
            Filter filterMember = filtersListValue;
            if (filterMember != null) {
                if (filterMember.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(filterMember.getName()));
                }
                List<String> valuesList = filterMember.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
            ++filtersListIndex;
        }
        return request;
    }
}

