/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.codedeploy.model.GetApplicationRevisionRequest;
import com.amazonaws.services.codedeploy.model.GitHubLocation;
import com.amazonaws.services.codedeploy.model.RevisionLocation;
import com.amazonaws.services.codedeploy.model.S3Location;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class GetApplicationRevisionRequestMarshaller
implements Marshaller<Request<GetApplicationRevisionRequest>, GetApplicationRevisionRequest> {
    @Override
    public Request<GetApplicationRevisionRequest> marshall(GetApplicationRevisionRequest getApplicationRevisionRequest) {
        if (getApplicationRevisionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetApplicationRevisionRequest> request = new DefaultRequest<GetApplicationRevisionRequest>(getApplicationRevisionRequest, "AmazonCodeDeploy");
        String target = "CodeDeploy_20141006.GetApplicationRevision";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            RevisionLocation revision;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (getApplicationRevisionRequest.getApplicationName() != null) {
                jsonWriter.key("applicationName").value(getApplicationRevisionRequest.getApplicationName());
            }
            if ((revision = getApplicationRevisionRequest.getRevision()) != null) {
                GitHubLocation gitHubLocation;
                S3Location s3Location;
                jsonWriter.key("revision");
                jsonWriter.object();
                if (revision.getRevisionType() != null) {
                    jsonWriter.key("revisionType").value(revision.getRevisionType());
                }
                if ((s3Location = revision.getS3Location()) != null) {
                    jsonWriter.key("s3Location");
                    jsonWriter.object();
                    if (s3Location.getBucket() != null) {
                        jsonWriter.key("bucket").value(s3Location.getBucket());
                    }
                    if (s3Location.getKey() != null) {
                        jsonWriter.key("key").value(s3Location.getKey());
                    }
                    if (s3Location.getBundleType() != null) {
                        jsonWriter.key("bundleType").value(s3Location.getBundleType());
                    }
                    if (s3Location.getVersion() != null) {
                        jsonWriter.key("version").value(s3Location.getVersion());
                    }
                    if (s3Location.getETag() != null) {
                        jsonWriter.key("eTag").value(s3Location.getETag());
                    }
                    jsonWriter.endObject();
                }
                if ((gitHubLocation = revision.getGitHubLocation()) != null) {
                    jsonWriter.key("gitHubLocation");
                    jsonWriter.object();
                    if (gitHubLocation.getRepository() != null) {
                        jsonWriter.key("repository").value(gitHubLocation.getRepository());
                    }
                    if (gitHubLocation.getCommitId() != null) {
                        jsonWriter.key("commitId").value(gitHubLocation.getCommitId());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

