/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.codedeploy.model.RevisionLocation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListApplicationRevisionsResult
implements Serializable {
    private ListWithAutoConstructFlag<RevisionLocation> revisions;
    private String nextToken;

    public List<RevisionLocation> getRevisions() {
        if (this.revisions == null) {
            this.revisions = new ListWithAutoConstructFlag();
            this.revisions.setAutoConstruct(true);
        }
        return this.revisions;
    }

    public void setRevisions(Collection<RevisionLocation> revisions) {
        if (revisions == null) {
            this.revisions = null;
            return;
        }
        ListWithAutoConstructFlag revisionsCopy = new ListWithAutoConstructFlag(revisions.size());
        revisionsCopy.addAll(revisions);
        this.revisions = revisionsCopy;
    }

    public ListApplicationRevisionsResult withRevisions(RevisionLocation ... revisions) {
        if (this.getRevisions() == null) {
            this.setRevisions(new ArrayList<RevisionLocation>(revisions.length));
        }
        for (RevisionLocation value : revisions) {
            this.getRevisions().add(value);
        }
        return this;
    }

    public ListApplicationRevisionsResult withRevisions(Collection<RevisionLocation> revisions) {
        if (revisions == null) {
            this.revisions = null;
        } else {
            ListWithAutoConstructFlag revisionsCopy = new ListWithAutoConstructFlag(revisions.size());
            revisionsCopy.addAll(revisions);
            this.revisions = revisionsCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListApplicationRevisionsResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRevisions() != null) {
            sb.append("Revisions: " + this.getRevisions() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRevisions() == null ? 0 : this.getRevisions().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationRevisionsResult)) {
            return false;
        }
        ListApplicationRevisionsResult other = (ListApplicationRevisionsResult)obj;
        if (other.getRevisions() == null ^ this.getRevisions() == null) {
            return false;
        }
        if (other.getRevisions() != null && !other.getRevisions().equals(this.getRevisions())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }
}

