/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mgn.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateReplicationConfigurationTemplate"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class UpdateReplicationConfigurationTemplateRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * Update replication configuration template ARN request.
     * </p>
     */
    private String arn;
    /**
     * <p>
     * Update replication configuration template associate default Application Migration Service Security group request.
     * </p>
     */
    private Boolean associateDefaultSecurityGroup;
    /**
     * <p>
     * Update replication configuration template bandwidth throttling request.
     * </p>
     */
    private Long bandwidthThrottling;
    /**
     * <p>
     * Update replication configuration template create Public IP request.
     * </p>
     */
    private Boolean createPublicIP;
    /**
     * <p>
     * Update replication configuration template data plane routing request.
     * </p>
     */
    private String dataPlaneRouting;
    /**
     * <p>
     * Update replication configuration template use default large Staging Disk type request.
     * </p>
     */
    private String defaultLargeStagingDiskType;
    /**
     * <p>
     * Update replication configuration template EBS encryption request.
     * </p>
     */
    private String ebsEncryption;
    /**
     * <p>
     * Update replication configuration template EBS encryption key ARN request.
     * </p>
     */
    private String ebsEncryptionKeyArn;
    /**
     * <p>
     * Update replication configuration template template ID request.
     * </p>
     */
    private String replicationConfigurationTemplateID;
    /**
     * <p>
     * Update replication configuration template Replication Server instance type request.
     * </p>
     */
    private String replicationServerInstanceType;
    /**
     * <p>
     * Update replication configuration template Replication Server Security groups IDs request.
     * </p>
     */
    private java.util.List<String> replicationServersSecurityGroupsIDs;
    /**
     * <p>
     * Update replication configuration template Staging Area subnet ID request.
     * </p>
     */
    private String stagingAreaSubnetId;
    /**
     * <p>
     * Update replication configuration template Staging Area Tags request.
     * </p>
     */
    private java.util.Map<String, String> stagingAreaTags;
    /**
     * <p>
     * Update replication configuration template use dedicated Replication Server request.
     * </p>
     */
    private Boolean useDedicatedReplicationServer;

    /**
     * <p>
     * Update replication configuration template ARN request.
     * </p>
     * 
     * @param arn
     *        Update replication configuration template ARN request.
     */

    public void setArn(String arn) {
        this.arn = arn;
    }

    /**
     * <p>
     * Update replication configuration template ARN request.
     * </p>
     * 
     * @return Update replication configuration template ARN request.
     */

    public String getArn() {
        return this.arn;
    }

    /**
     * <p>
     * Update replication configuration template ARN request.
     * </p>
     * 
     * @param arn
     *        Update replication configuration template ARN request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateReplicationConfigurationTemplateRequest withArn(String arn) {
        setArn(arn);
        return this;
    }

    /**
     * <p>
     * Update replication configuration template associate default Application Migration Service Security group request.
     * </p>
     * 
     * @param associateDefaultSecurityGroup
     *        Update replication configuration template associate default Application Migration Service Security group
     *        request.
     */

    public void setAssociateDefaultSecurityGroup(Boolean associateDefaultSecurityGroup) {
        this.associateDefaultSecurityGroup = associateDefaultSecurityGroup;
    }

    /**
     * <p>
     * Update replication configuration template associate default Application Migration Service Security group request.
     * </p>
     * 
     * @return Update replication configuration template associate default Application Migration Service Security group
     *         request.
     */

    public Boolean getAssociateDefaultSecurityGroup() {
        return this.associateDefaultSecurityGroup;
    }

    /**
     * <p>
     * Update replication configuration template associate default Application Migration Service Security group request.
     * </p>
     * 
     * @param associateDefaultSecurityGroup
     *        Update replication configuration template associate default Application Migration Service Security group
     *        request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateReplicationConfigurationTemplateRequest withAssociateDefaultSecurityGroup(Boolean associateDefaultSecurityGroup) {
        setAssociateDefaultSecurityGroup(associateDefaultSecurityGroup);
        return this;
    }

    /**
     * <p>
     * Update replication configuration template associate default Application Migration Service Security group request.
     * </p>
     * 
     * @return Update replication configuration template associate default Application Migration Service Security group
     *         request.
     */

    public Boolean isAssociateDefaultSecurityGroup() {
        return this.associateDefaultSecurityGroup;
    }

    /**
     * <p>
     * Update replication configuration template bandwidth throttling request.
     * </p>
     * 
     * @param bandwidthThrottling
     *        Update replication configuration template bandwidth throttling request.
     */

    public void setBandwidthThrottling(Long bandwidthThrottling) {
        this.bandwidthThrottling = bandwidthThrottling;
    }

    /**
     * <p>
     * Update replication configuration template bandwidth throttling request.
     * </p>
     * 
     * @return Update replication configuration template bandwidth throttling request.
     */

    public Long getBandwidthThrottling() {
        return this.bandwidthThrottling;
    }

    /**
     * <p>
     * Update replication configuration template bandwidth throttling request.
     * </p>
     * 
     * @param bandwidthThrottling
     *        Update replication configuration template bandwidth throttling request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateReplicationConfigurationTemplateRequest withBandwidthThrottling(Long bandwidthThrottling) {
        setBandwidthThrottling(bandwidthThrottling);
        return this;
    }

    /**
     * <p>
     * Update replication configuration template create Public IP request.
     * </p>
     * 
     * @param createPublicIP
     *        Update replication configuration template create Public IP request.
     */

    public void setCreatePublicIP(Boolean createPublicIP) {
        this.createPublicIP = createPublicIP;
    }

    /**
     * <p>
     * Update replication configuration template create Public IP request.
     * </p>
     * 
     * @return Update replication configuration template create Public IP request.
     */

    public Boolean getCreatePublicIP() {
        return this.createPublicIP;
    }

    /**
     * <p>
     * Update replication configuration template create Public IP request.
     * </p>
     * 
     * @param createPublicIP
     *        Update replication configuration template create Public IP request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateReplicationConfigurationTemplateRequest withCreatePublicIP(Boolean createPublicIP) {
        setCreatePublicIP(createPublicIP);
        return this;
    }

    /**
     * <p>
     * Update replication configuration template create Public IP request.
     * </p>
     * 
     * @return Update replication configuration template create Public IP request.
     */

    public Boolean isCreatePublicIP() {
        return this.createPublicIP;
    }

    /**
     * <p>
     * Update replication configuration template data plane routing request.
     * </p>
     * 
     * @param dataPlaneRouting
     *        Update replication configuration template data plane routing request.
     * @see ReplicationConfigurationDataPlaneRouting
     */

    public void setDataPlaneRouting(String dataPlaneRouting) {
        this.dataPlaneRouting = dataPlaneRouting;
    }

    /**
     * <p>
     * Update replication configuration template data plane routing request.
     * </p>
     * 
     * @return Update replication configuration template data plane routing request.
     * @see ReplicationConfigurationDataPlaneRouting
     */

    public String getDataPlaneRouting() {
        return this.dataPlaneRouting;
    }

    /**
     * <p>
     * Update replication configuration template data plane routing request.
     * </p>
     * 
     * @param dataPlaneRouting
     *        Update replication configuration template data plane routing request.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ReplicationConfigurationDataPlaneRouting
     */

    public UpdateReplicationConfigurationTemplateRequest withDataPlaneRouting(String dataPlaneRouting) {
        setDataPlaneRouting(dataPlaneRouting);
        return this;
    }

    /**
     * <p>
     * Update replication configuration template data plane routing request.
     * </p>
     * 
     * @param dataPlaneRouting
     *        Update replication configuration template data plane routing request.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ReplicationConfigurationDataPlaneRouting
     */

    public UpdateReplicationConfigurationTemplateRequest withDataPlaneRouting(ReplicationConfigurationDataPlaneRouting dataPlaneRouting) {
        this.dataPlaneRouting = dataPlaneRouting.toString();
        return this;
    }

    /**
     * <p>
     * Update replication configuration template use default large Staging Disk type request.
     * </p>
     * 
     * @param defaultLargeStagingDiskType
     *        Update replication configuration template use default large Staging Disk type request.
     * @see ReplicationConfigurationDefaultLargeStagingDiskType
     */

    public void setDefaultLargeStagingDiskType(String defaultLargeStagingDiskType) {
        this.defaultLargeStagingDiskType = defaultLargeStagingDiskType;
    }

    /**
     * <p>
     * Update replication configuration template use default large Staging Disk type request.
     * </p>
     * 
     * @return Update replication configuration template use default large Staging Disk type request.
     * @see ReplicationConfigurationDefaultLargeStagingDiskType
     */

    public String getDefaultLargeStagingDiskType() {
        return this.defaultLargeStagingDiskType;
    }

    /**
     * <p>
     * Update replication configuration template use default large Staging Disk type request.
     * </p>
     * 
     * @param defaultLargeStagingDiskType
     *        Update replication configuration template use default large Staging Disk type request.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ReplicationConfigurationDefaultLargeStagingDiskType
     */

    public UpdateReplicationConfigurationTemplateRequest withDefaultLargeStagingDiskType(String defaultLargeStagingDiskType) {
        setDefaultLargeStagingDiskType(defaultLargeStagingDiskType);
        return this;
    }

    /**
     * <p>
     * Update replication configuration template use default large Staging Disk type request.
     * </p>
     * 
     * @param defaultLargeStagingDiskType
     *        Update replication configuration template use default large Staging Disk type request.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ReplicationConfigurationDefaultLargeStagingDiskType
     */

    public UpdateReplicationConfigurationTemplateRequest withDefaultLargeStagingDiskType(
            ReplicationConfigurationDefaultLargeStagingDiskType defaultLargeStagingDiskType) {
        this.defaultLargeStagingDiskType = defaultLargeStagingDiskType.toString();
        return this;
    }

    /**
     * <p>
     * Update replication configuration template EBS encryption request.
     * </p>
     * 
     * @param ebsEncryption
     *        Update replication configuration template EBS encryption request.
     * @see ReplicationConfigurationEbsEncryption
     */

    public void setEbsEncryption(String ebsEncryption) {
        this.ebsEncryption = ebsEncryption;
    }

    /**
     * <p>
     * Update replication configuration template EBS encryption request.
     * </p>
     * 
     * @return Update replication configuration template EBS encryption request.
     * @see ReplicationConfigurationEbsEncryption
     */

    public String getEbsEncryption() {
        return this.ebsEncryption;
    }

    /**
     * <p>
     * Update replication configuration template EBS encryption request.
     * </p>
     * 
     * @param ebsEncryption
     *        Update replication configuration template EBS encryption request.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ReplicationConfigurationEbsEncryption
     */

    public UpdateReplicationConfigurationTemplateRequest withEbsEncryption(String ebsEncryption) {
        setEbsEncryption(ebsEncryption);
        return this;
    }

    /**
     * <p>
     * Update replication configuration template EBS encryption request.
     * </p>
     * 
     * @param ebsEncryption
     *        Update replication configuration template EBS encryption request.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ReplicationConfigurationEbsEncryption
     */

    public UpdateReplicationConfigurationTemplateRequest withEbsEncryption(ReplicationConfigurationEbsEncryption ebsEncryption) {
        this.ebsEncryption = ebsEncryption.toString();
        return this;
    }

    /**
     * <p>
     * Update replication configuration template EBS encryption key ARN request.
     * </p>
     * 
     * @param ebsEncryptionKeyArn
     *        Update replication configuration template EBS encryption key ARN request.
     */

    public void setEbsEncryptionKeyArn(String ebsEncryptionKeyArn) {
        this.ebsEncryptionKeyArn = ebsEncryptionKeyArn;
    }

    /**
     * <p>
     * Update replication configuration template EBS encryption key ARN request.
     * </p>
     * 
     * @return Update replication configuration template EBS encryption key ARN request.
     */

    public String getEbsEncryptionKeyArn() {
        return this.ebsEncryptionKeyArn;
    }

    /**
     * <p>
     * Update replication configuration template EBS encryption key ARN request.
     * </p>
     * 
     * @param ebsEncryptionKeyArn
     *        Update replication configuration template EBS encryption key ARN request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateReplicationConfigurationTemplateRequest withEbsEncryptionKeyArn(String ebsEncryptionKeyArn) {
        setEbsEncryptionKeyArn(ebsEncryptionKeyArn);
        return this;
    }

    /**
     * <p>
     * Update replication configuration template template ID request.
     * </p>
     * 
     * @param replicationConfigurationTemplateID
     *        Update replication configuration template template ID request.
     */

    public void setReplicationConfigurationTemplateID(String replicationConfigurationTemplateID) {
        this.replicationConfigurationTemplateID = replicationConfigurationTemplateID;
    }

    /**
     * <p>
     * Update replication configuration template template ID request.
     * </p>
     * 
     * @return Update replication configuration template template ID request.
     */

    public String getReplicationConfigurationTemplateID() {
        return this.replicationConfigurationTemplateID;
    }

    /**
     * <p>
     * Update replication configuration template template ID request.
     * </p>
     * 
     * @param replicationConfigurationTemplateID
     *        Update replication configuration template template ID request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateReplicationConfigurationTemplateRequest withReplicationConfigurationTemplateID(String replicationConfigurationTemplateID) {
        setReplicationConfigurationTemplateID(replicationConfigurationTemplateID);
        return this;
    }

    /**
     * <p>
     * Update replication configuration template Replication Server instance type request.
     * </p>
     * 
     * @param replicationServerInstanceType
     *        Update replication configuration template Replication Server instance type request.
     */

    public void setReplicationServerInstanceType(String replicationServerInstanceType) {
        this.replicationServerInstanceType = replicationServerInstanceType;
    }

    /**
     * <p>
     * Update replication configuration template Replication Server instance type request.
     * </p>
     * 
     * @return Update replication configuration template Replication Server instance type request.
     */

    public String getReplicationServerInstanceType() {
        return this.replicationServerInstanceType;
    }

    /**
     * <p>
     * Update replication configuration template Replication Server instance type request.
     * </p>
     * 
     * @param replicationServerInstanceType
     *        Update replication configuration template Replication Server instance type request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateReplicationConfigurationTemplateRequest withReplicationServerInstanceType(String replicationServerInstanceType) {
        setReplicationServerInstanceType(replicationServerInstanceType);
        return this;
    }

    /**
     * <p>
     * Update replication configuration template Replication Server Security groups IDs request.
     * </p>
     * 
     * @return Update replication configuration template Replication Server Security groups IDs request.
     */

    public java.util.List<String> getReplicationServersSecurityGroupsIDs() {
        return replicationServersSecurityGroupsIDs;
    }

    /**
     * <p>
     * Update replication configuration template Replication Server Security groups IDs request.
     * </p>
     * 
     * @param replicationServersSecurityGroupsIDs
     *        Update replication configuration template Replication Server Security groups IDs request.
     */

    public void setReplicationServersSecurityGroupsIDs(java.util.Collection<String> replicationServersSecurityGroupsIDs) {
        if (replicationServersSecurityGroupsIDs == null) {
            this.replicationServersSecurityGroupsIDs = null;
            return;
        }

        this.replicationServersSecurityGroupsIDs = new java.util.ArrayList<String>(replicationServersSecurityGroupsIDs);
    }

    /**
     * <p>
     * Update replication configuration template Replication Server Security groups IDs request.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setReplicationServersSecurityGroupsIDs(java.util.Collection)} or
     * {@link #withReplicationServersSecurityGroupsIDs(java.util.Collection)} if you want to override the existing
     * values.
     * </p>
     * 
     * @param replicationServersSecurityGroupsIDs
     *        Update replication configuration template Replication Server Security groups IDs request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateReplicationConfigurationTemplateRequest withReplicationServersSecurityGroupsIDs(String... replicationServersSecurityGroupsIDs) {
        if (this.replicationServersSecurityGroupsIDs == null) {
            setReplicationServersSecurityGroupsIDs(new java.util.ArrayList<String>(replicationServersSecurityGroupsIDs.length));
        }
        for (String ele : replicationServersSecurityGroupsIDs) {
            this.replicationServersSecurityGroupsIDs.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Update replication configuration template Replication Server Security groups IDs request.
     * </p>
     * 
     * @param replicationServersSecurityGroupsIDs
     *        Update replication configuration template Replication Server Security groups IDs request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateReplicationConfigurationTemplateRequest withReplicationServersSecurityGroupsIDs(
            java.util.Collection<String> replicationServersSecurityGroupsIDs) {
        setReplicationServersSecurityGroupsIDs(replicationServersSecurityGroupsIDs);
        return this;
    }

    /**
     * <p>
     * Update replication configuration template Staging Area subnet ID request.
     * </p>
     * 
     * @param stagingAreaSubnetId
     *        Update replication configuration template Staging Area subnet ID request.
     */

    public void setStagingAreaSubnetId(String stagingAreaSubnetId) {
        this.stagingAreaSubnetId = stagingAreaSubnetId;
    }

    /**
     * <p>
     * Update replication configuration template Staging Area subnet ID request.
     * </p>
     * 
     * @return Update replication configuration template Staging Area subnet ID request.
     */

    public String getStagingAreaSubnetId() {
        return this.stagingAreaSubnetId;
    }

    /**
     * <p>
     * Update replication configuration template Staging Area subnet ID request.
     * </p>
     * 
     * @param stagingAreaSubnetId
     *        Update replication configuration template Staging Area subnet ID request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateReplicationConfigurationTemplateRequest withStagingAreaSubnetId(String stagingAreaSubnetId) {
        setStagingAreaSubnetId(stagingAreaSubnetId);
        return this;
    }

    /**
     * <p>
     * Update replication configuration template Staging Area Tags request.
     * </p>
     * 
     * @return Update replication configuration template Staging Area Tags request.
     */

    public java.util.Map<String, String> getStagingAreaTags() {
        return stagingAreaTags;
    }

    /**
     * <p>
     * Update replication configuration template Staging Area Tags request.
     * </p>
     * 
     * @param stagingAreaTags
     *        Update replication configuration template Staging Area Tags request.
     */

    public void setStagingAreaTags(java.util.Map<String, String> stagingAreaTags) {
        this.stagingAreaTags = stagingAreaTags;
    }

    /**
     * <p>
     * Update replication configuration template Staging Area Tags request.
     * </p>
     * 
     * @param stagingAreaTags
     *        Update replication configuration template Staging Area Tags request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateReplicationConfigurationTemplateRequest withStagingAreaTags(java.util.Map<String, String> stagingAreaTags) {
        setStagingAreaTags(stagingAreaTags);
        return this;
    }

    /**
     * Add a single StagingAreaTags entry
     *
     * @see UpdateReplicationConfigurationTemplateRequest#withStagingAreaTags
     * @returns a reference to this object so that method calls can be chained together.
     */

    public UpdateReplicationConfigurationTemplateRequest addStagingAreaTagsEntry(String key, String value) {
        if (null == this.stagingAreaTags) {
            this.stagingAreaTags = new java.util.HashMap<String, String>();
        }
        if (this.stagingAreaTags.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.stagingAreaTags.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into StagingAreaTags.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateReplicationConfigurationTemplateRequest clearStagingAreaTagsEntries() {
        this.stagingAreaTags = null;
        return this;
    }

    /**
     * <p>
     * Update replication configuration template use dedicated Replication Server request.
     * </p>
     * 
     * @param useDedicatedReplicationServer
     *        Update replication configuration template use dedicated Replication Server request.
     */

    public void setUseDedicatedReplicationServer(Boolean useDedicatedReplicationServer) {
        this.useDedicatedReplicationServer = useDedicatedReplicationServer;
    }

    /**
     * <p>
     * Update replication configuration template use dedicated Replication Server request.
     * </p>
     * 
     * @return Update replication configuration template use dedicated Replication Server request.
     */

    public Boolean getUseDedicatedReplicationServer() {
        return this.useDedicatedReplicationServer;
    }

    /**
     * <p>
     * Update replication configuration template use dedicated Replication Server request.
     * </p>
     * 
     * @param useDedicatedReplicationServer
     *        Update replication configuration template use dedicated Replication Server request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateReplicationConfigurationTemplateRequest withUseDedicatedReplicationServer(Boolean useDedicatedReplicationServer) {
        setUseDedicatedReplicationServer(useDedicatedReplicationServer);
        return this;
    }

    /**
     * <p>
     * Update replication configuration template use dedicated Replication Server request.
     * </p>
     * 
     * @return Update replication configuration template use dedicated Replication Server request.
     */

    public Boolean isUseDedicatedReplicationServer() {
        return this.useDedicatedReplicationServer;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getArn() != null)
            sb.append("Arn: ").append(getArn()).append(",");
        if (getAssociateDefaultSecurityGroup() != null)
            sb.append("AssociateDefaultSecurityGroup: ").append(getAssociateDefaultSecurityGroup()).append(",");
        if (getBandwidthThrottling() != null)
            sb.append("BandwidthThrottling: ").append(getBandwidthThrottling()).append(",");
        if (getCreatePublicIP() != null)
            sb.append("CreatePublicIP: ").append(getCreatePublicIP()).append(",");
        if (getDataPlaneRouting() != null)
            sb.append("DataPlaneRouting: ").append(getDataPlaneRouting()).append(",");
        if (getDefaultLargeStagingDiskType() != null)
            sb.append("DefaultLargeStagingDiskType: ").append(getDefaultLargeStagingDiskType()).append(",");
        if (getEbsEncryption() != null)
            sb.append("EbsEncryption: ").append(getEbsEncryption()).append(",");
        if (getEbsEncryptionKeyArn() != null)
            sb.append("EbsEncryptionKeyArn: ").append(getEbsEncryptionKeyArn()).append(",");
        if (getReplicationConfigurationTemplateID() != null)
            sb.append("ReplicationConfigurationTemplateID: ").append(getReplicationConfigurationTemplateID()).append(",");
        if (getReplicationServerInstanceType() != null)
            sb.append("ReplicationServerInstanceType: ").append(getReplicationServerInstanceType()).append(",");
        if (getReplicationServersSecurityGroupsIDs() != null)
            sb.append("ReplicationServersSecurityGroupsIDs: ").append(getReplicationServersSecurityGroupsIDs()).append(",");
        if (getStagingAreaSubnetId() != null)
            sb.append("StagingAreaSubnetId: ").append(getStagingAreaSubnetId()).append(",");
        if (getStagingAreaTags() != null)
            sb.append("StagingAreaTags: ").append("***Sensitive Data Redacted***").append(",");
        if (getUseDedicatedReplicationServer() != null)
            sb.append("UseDedicatedReplicationServer: ").append(getUseDedicatedReplicationServer());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof UpdateReplicationConfigurationTemplateRequest == false)
            return false;
        UpdateReplicationConfigurationTemplateRequest other = (UpdateReplicationConfigurationTemplateRequest) obj;
        if (other.getArn() == null ^ this.getArn() == null)
            return false;
        if (other.getArn() != null && other.getArn().equals(this.getArn()) == false)
            return false;
        if (other.getAssociateDefaultSecurityGroup() == null ^ this.getAssociateDefaultSecurityGroup() == null)
            return false;
        if (other.getAssociateDefaultSecurityGroup() != null
                && other.getAssociateDefaultSecurityGroup().equals(this.getAssociateDefaultSecurityGroup()) == false)
            return false;
        if (other.getBandwidthThrottling() == null ^ this.getBandwidthThrottling() == null)
            return false;
        if (other.getBandwidthThrottling() != null && other.getBandwidthThrottling().equals(this.getBandwidthThrottling()) == false)
            return false;
        if (other.getCreatePublicIP() == null ^ this.getCreatePublicIP() == null)
            return false;
        if (other.getCreatePublicIP() != null && other.getCreatePublicIP().equals(this.getCreatePublicIP()) == false)
            return false;
        if (other.getDataPlaneRouting() == null ^ this.getDataPlaneRouting() == null)
            return false;
        if (other.getDataPlaneRouting() != null && other.getDataPlaneRouting().equals(this.getDataPlaneRouting()) == false)
            return false;
        if (other.getDefaultLargeStagingDiskType() == null ^ this.getDefaultLargeStagingDiskType() == null)
            return false;
        if (other.getDefaultLargeStagingDiskType() != null && other.getDefaultLargeStagingDiskType().equals(this.getDefaultLargeStagingDiskType()) == false)
            return false;
        if (other.getEbsEncryption() == null ^ this.getEbsEncryption() == null)
            return false;
        if (other.getEbsEncryption() != null && other.getEbsEncryption().equals(this.getEbsEncryption()) == false)
            return false;
        if (other.getEbsEncryptionKeyArn() == null ^ this.getEbsEncryptionKeyArn() == null)
            return false;
        if (other.getEbsEncryptionKeyArn() != null && other.getEbsEncryptionKeyArn().equals(this.getEbsEncryptionKeyArn()) == false)
            return false;
        if (other.getReplicationConfigurationTemplateID() == null ^ this.getReplicationConfigurationTemplateID() == null)
            return false;
        if (other.getReplicationConfigurationTemplateID() != null
                && other.getReplicationConfigurationTemplateID().equals(this.getReplicationConfigurationTemplateID()) == false)
            return false;
        if (other.getReplicationServerInstanceType() == null ^ this.getReplicationServerInstanceType() == null)
            return false;
        if (other.getReplicationServerInstanceType() != null
                && other.getReplicationServerInstanceType().equals(this.getReplicationServerInstanceType()) == false)
            return false;
        if (other.getReplicationServersSecurityGroupsIDs() == null ^ this.getReplicationServersSecurityGroupsIDs() == null)
            return false;
        if (other.getReplicationServersSecurityGroupsIDs() != null
                && other.getReplicationServersSecurityGroupsIDs().equals(this.getReplicationServersSecurityGroupsIDs()) == false)
            return false;
        if (other.getStagingAreaSubnetId() == null ^ this.getStagingAreaSubnetId() == null)
            return false;
        if (other.getStagingAreaSubnetId() != null && other.getStagingAreaSubnetId().equals(this.getStagingAreaSubnetId()) == false)
            return false;
        if (other.getStagingAreaTags() == null ^ this.getStagingAreaTags() == null)
            return false;
        if (other.getStagingAreaTags() != null && other.getStagingAreaTags().equals(this.getStagingAreaTags()) == false)
            return false;
        if (other.getUseDedicatedReplicationServer() == null ^ this.getUseDedicatedReplicationServer() == null)
            return false;
        if (other.getUseDedicatedReplicationServer() != null
                && other.getUseDedicatedReplicationServer().equals(this.getUseDedicatedReplicationServer()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getArn() == null) ? 0 : getArn().hashCode());
        hashCode = prime * hashCode + ((getAssociateDefaultSecurityGroup() == null) ? 0 : getAssociateDefaultSecurityGroup().hashCode());
        hashCode = prime * hashCode + ((getBandwidthThrottling() == null) ? 0 : getBandwidthThrottling().hashCode());
        hashCode = prime * hashCode + ((getCreatePublicIP() == null) ? 0 : getCreatePublicIP().hashCode());
        hashCode = prime * hashCode + ((getDataPlaneRouting() == null) ? 0 : getDataPlaneRouting().hashCode());
        hashCode = prime * hashCode + ((getDefaultLargeStagingDiskType() == null) ? 0 : getDefaultLargeStagingDiskType().hashCode());
        hashCode = prime * hashCode + ((getEbsEncryption() == null) ? 0 : getEbsEncryption().hashCode());
        hashCode = prime * hashCode + ((getEbsEncryptionKeyArn() == null) ? 0 : getEbsEncryptionKeyArn().hashCode());
        hashCode = prime * hashCode + ((getReplicationConfigurationTemplateID() == null) ? 0 : getReplicationConfigurationTemplateID().hashCode());
        hashCode = prime * hashCode + ((getReplicationServerInstanceType() == null) ? 0 : getReplicationServerInstanceType().hashCode());
        hashCode = prime * hashCode + ((getReplicationServersSecurityGroupsIDs() == null) ? 0 : getReplicationServersSecurityGroupsIDs().hashCode());
        hashCode = prime * hashCode + ((getStagingAreaSubnetId() == null) ? 0 : getStagingAreaSubnetId().hashCode());
        hashCode = prime * hashCode + ((getStagingAreaTags() == null) ? 0 : getStagingAreaTags().hashCode());
        hashCode = prime * hashCode + ((getUseDedicatedReplicationServer() == null) ? 0 : getUseDedicatedReplicationServer().hashCode());
        return hashCode;
    }

    @Override
    public UpdateReplicationConfigurationTemplateRequest clone() {
        return (UpdateReplicationConfigurationTemplateRequest) super.clone();
    }

}
