/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.cloudfront.AmazonCloudFront;
import com.amazonaws.services.cloudfront.model.GetDistributionRequest;
import com.amazonaws.services.cloudfront.model.GetDistributionResult;
import com.amazonaws.services.cloudfront.model.GetInvalidationRequest;
import com.amazonaws.services.cloudfront.model.GetInvalidationResult;
import com.amazonaws.services.cloudfront.model.GetStreamingDistributionRequest;
import com.amazonaws.services.cloudfront.model.GetStreamingDistributionResult;
import com.amazonaws.services.cloudfront.waiters.DistributionDeployed;
import com.amazonaws.services.cloudfront.waiters.GetDistributionFunction;
import com.amazonaws.services.cloudfront.waiters.GetInvalidationFunction;
import com.amazonaws.services.cloudfront.waiters.GetStreamingDistributionFunction;
import com.amazonaws.services.cloudfront.waiters.InvalidationCompleted;
import com.amazonaws.services.cloudfront.waiters.StreamingDistributionDeployed;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AmazonCloudFrontWaiters {
    private final AmazonCloudFront client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonCloudFrontWaiters(AmazonCloudFront client) {
        this.client = client;
    }

    public Waiter<GetDistributionRequest> distributionDeployed() {
        return new WaiterBuilder<GetDistributionRequest, GetDistributionResult>().withSdkFunction(new GetDistributionFunction(this.client)).withAcceptors(new DistributionDeployed.IsDeployedMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(25), new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetStreamingDistributionRequest> streamingDistributionDeployed() {
        return new WaiterBuilder<GetStreamingDistributionRequest, GetStreamingDistributionResult>().withSdkFunction(new GetStreamingDistributionFunction(this.client)).withAcceptors(new StreamingDistributionDeployed.IsDeployedMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(25), new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetInvalidationRequest> invalidationCompleted() {
        return new WaiterBuilder<GetInvalidationRequest, GetInvalidationResult>().withSdkFunction(new GetInvalidationFunction(this.client)).withAcceptors(new InvalidationCompleted.IsCompletedMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(30), new FixedDelayStrategy(20))).withExecutorService(this.executorService).build();
    }
}

