/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.servicecatalog.model.ListRecordHistoryRequest;
import com.amazonaws.services.servicecatalog.model.transform.AccessLevelFilterJsonMarshaller;
import com.amazonaws.services.servicecatalog.model.transform.ListRecordHistorySearchFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListRecordHistoryRequestMarshaller
implements Marshaller<Request<ListRecordHistoryRequest>, ListRecordHistoryRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListRecordHistoryRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListRecordHistoryRequest> marshall(ListRecordHistoryRequest listRecordHistoryRequest) {
        if (listRecordHistoryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListRecordHistoryRequest> request = new DefaultRequest<ListRecordHistoryRequest>(listRecordHistoryRequest, "AWSServiceCatalog");
        request.addHeader("X-Amz-Target", "AWS242ServiceCatalogService.ListRecordHistory");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listRecordHistoryRequest.getAcceptLanguage() != null) {
                jsonGenerator.writeFieldName("AcceptLanguage").writeValue(listRecordHistoryRequest.getAcceptLanguage());
            }
            if (listRecordHistoryRequest.getAccessLevelFilter() != null) {
                jsonGenerator.writeFieldName("AccessLevelFilter");
                AccessLevelFilterJsonMarshaller.getInstance().marshall(listRecordHistoryRequest.getAccessLevelFilter(), jsonGenerator);
            }
            if (listRecordHistoryRequest.getSearchFilter() != null) {
                jsonGenerator.writeFieldName("SearchFilter");
                ListRecordHistorySearchFilterJsonMarshaller.getInstance().marshall(listRecordHistoryRequest.getSearchFilter(), jsonGenerator);
            }
            if (listRecordHistoryRequest.getPageSize() != null) {
                jsonGenerator.writeFieldName("PageSize").writeValue(listRecordHistoryRequest.getPageSize());
            }
            if (listRecordHistoryRequest.getPageToken() != null) {
                jsonGenerator.writeFieldName("PageToken").writeValue(listRecordHistoryRequest.getPageToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

