/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.codebuild.AWSCodeBuild;
import com.amazonaws.services.codebuild.AWSCodeBuildClientBuilder;
import com.amazonaws.services.codebuild.model.AWSCodeBuildException;
import com.amazonaws.services.codebuild.model.AccountLimitExceededException;
import com.amazonaws.services.codebuild.model.BatchGetBuildsRequest;
import com.amazonaws.services.codebuild.model.BatchGetBuildsResult;
import com.amazonaws.services.codebuild.model.BatchGetProjectsRequest;
import com.amazonaws.services.codebuild.model.BatchGetProjectsResult;
import com.amazonaws.services.codebuild.model.CreateProjectRequest;
import com.amazonaws.services.codebuild.model.CreateProjectResult;
import com.amazonaws.services.codebuild.model.DeleteProjectRequest;
import com.amazonaws.services.codebuild.model.DeleteProjectResult;
import com.amazonaws.services.codebuild.model.InvalidInputException;
import com.amazonaws.services.codebuild.model.ListBuildsForProjectRequest;
import com.amazonaws.services.codebuild.model.ListBuildsForProjectResult;
import com.amazonaws.services.codebuild.model.ListBuildsRequest;
import com.amazonaws.services.codebuild.model.ListBuildsResult;
import com.amazonaws.services.codebuild.model.ListCuratedEnvironmentImagesRequest;
import com.amazonaws.services.codebuild.model.ListCuratedEnvironmentImagesResult;
import com.amazonaws.services.codebuild.model.ListProjectsRequest;
import com.amazonaws.services.codebuild.model.ListProjectsResult;
import com.amazonaws.services.codebuild.model.ResourceAlreadyExistsException;
import com.amazonaws.services.codebuild.model.ResourceNotFoundException;
import com.amazonaws.services.codebuild.model.StartBuildRequest;
import com.amazonaws.services.codebuild.model.StartBuildResult;
import com.amazonaws.services.codebuild.model.StopBuildRequest;
import com.amazonaws.services.codebuild.model.StopBuildResult;
import com.amazonaws.services.codebuild.model.UpdateProjectRequest;
import com.amazonaws.services.codebuild.model.UpdateProjectResult;
import com.amazonaws.services.codebuild.model.transform.BatchGetBuildsRequestMarshaller;
import com.amazonaws.services.codebuild.model.transform.BatchGetBuildsResultJsonUnmarshaller;
import com.amazonaws.services.codebuild.model.transform.BatchGetProjectsRequestMarshaller;
import com.amazonaws.services.codebuild.model.transform.BatchGetProjectsResultJsonUnmarshaller;
import com.amazonaws.services.codebuild.model.transform.CreateProjectRequestMarshaller;
import com.amazonaws.services.codebuild.model.transform.CreateProjectResultJsonUnmarshaller;
import com.amazonaws.services.codebuild.model.transform.DeleteProjectRequestMarshaller;
import com.amazonaws.services.codebuild.model.transform.DeleteProjectResultJsonUnmarshaller;
import com.amazonaws.services.codebuild.model.transform.ListBuildsForProjectRequestMarshaller;
import com.amazonaws.services.codebuild.model.transform.ListBuildsForProjectResultJsonUnmarshaller;
import com.amazonaws.services.codebuild.model.transform.ListBuildsRequestMarshaller;
import com.amazonaws.services.codebuild.model.transform.ListBuildsResultJsonUnmarshaller;
import com.amazonaws.services.codebuild.model.transform.ListCuratedEnvironmentImagesRequestMarshaller;
import com.amazonaws.services.codebuild.model.transform.ListCuratedEnvironmentImagesResultJsonUnmarshaller;
import com.amazonaws.services.codebuild.model.transform.ListProjectsRequestMarshaller;
import com.amazonaws.services.codebuild.model.transform.ListProjectsResultJsonUnmarshaller;
import com.amazonaws.services.codebuild.model.transform.StartBuildRequestMarshaller;
import com.amazonaws.services.codebuild.model.transform.StartBuildResultJsonUnmarshaller;
import com.amazonaws.services.codebuild.model.transform.StopBuildRequestMarshaller;
import com.amazonaws.services.codebuild.model.transform.StopBuildResultJsonUnmarshaller;
import com.amazonaws.services.codebuild.model.transform.UpdateProjectRequestMarshaller;
import com.amazonaws.services.codebuild.model.transform.UpdateProjectResultJsonUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSCodeBuildClient
extends AmazonWebServiceClient
implements AWSCodeBuild {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSCodeBuild.class);
    private static final String DEFAULT_SIGNING_NAME = "codebuild";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidInputException").withModeledClass(InvalidInputException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccountLimitExceededException").withModeledClass(AccountLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceAlreadyExistsException").withModeledClass(ResourceAlreadyExistsException.class)).withBaseServiceExceptionClass(AWSCodeBuildException.class));

    @Deprecated
    public AWSCodeBuildClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AWSCodeBuildClient(ClientConfiguration clientConfiguration) {
        this(DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AWSCodeBuildClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AWSCodeBuildClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    @Deprecated
    public AWSCodeBuildClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AWSCodeBuildClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AWSCodeBuildClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    public static AWSCodeBuildClientBuilder builder() {
        return AWSCodeBuildClientBuilder.standard();
    }

    AWSCodeBuildClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("codebuild.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/codebuild/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/codebuild/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetBuildsResult batchGetBuilds(BatchGetBuildsRequest batchGetBuildsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchGetBuildsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchGetBuildsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchGetBuildsRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(batchGetBuildsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new BatchGetBuildsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchGetBuildsResult batchGetBuildsResult = (BatchGetBuildsResult)response.getAwsResponse();
            return batchGetBuildsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetProjectsResult batchGetProjects(BatchGetProjectsRequest batchGetProjectsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchGetProjectsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchGetProjectsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchGetProjectsRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(batchGetProjectsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new BatchGetProjectsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchGetProjectsResult batchGetProjectsResult = (BatchGetProjectsResult)response.getAwsResponse();
            return batchGetProjectsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateProjectResult createProject(CreateProjectRequest createProjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createProjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateProjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateProjectRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(createProjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateProjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateProjectResult createProjectResult = (CreateProjectResult)response.getAwsResponse();
            return createProjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteProjectResult deleteProject(DeleteProjectRequest deleteProjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteProjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteProjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteProjectRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(deleteProjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteProjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteProjectResult deleteProjectResult = (DeleteProjectResult)response.getAwsResponse();
            return deleteProjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBuildsResult listBuilds(ListBuildsRequest listBuildsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listBuildsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListBuildsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListBuildsRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(listBuildsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListBuildsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListBuildsResult listBuildsResult = (ListBuildsResult)response.getAwsResponse();
            return listBuildsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBuildsForProjectResult listBuildsForProject(ListBuildsForProjectRequest listBuildsForProjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listBuildsForProjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListBuildsForProjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListBuildsForProjectRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(listBuildsForProjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListBuildsForProjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListBuildsForProjectResult listBuildsForProjectResult = (ListBuildsForProjectResult)response.getAwsResponse();
            return listBuildsForProjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCuratedEnvironmentImagesResult listCuratedEnvironmentImages(ListCuratedEnvironmentImagesRequest listCuratedEnvironmentImagesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listCuratedEnvironmentImagesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListCuratedEnvironmentImagesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListCuratedEnvironmentImagesRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(listCuratedEnvironmentImagesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListCuratedEnvironmentImagesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListCuratedEnvironmentImagesResult listCuratedEnvironmentImagesResult = (ListCuratedEnvironmentImagesResult)response.getAwsResponse();
            return listCuratedEnvironmentImagesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListProjectsResult listProjects(ListProjectsRequest listProjectsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listProjectsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListProjectsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListProjectsRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(listProjectsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListProjectsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListProjectsResult listProjectsResult = (ListProjectsResult)response.getAwsResponse();
            return listProjectsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartBuildResult startBuild(StartBuildRequest startBuildRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startBuildRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartBuildRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartBuildRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(startBuildRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new StartBuildResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartBuildResult startBuildResult = (StartBuildResult)response.getAwsResponse();
            return startBuildResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopBuildResult stopBuild(StopBuildRequest stopBuildRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopBuildRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopBuildRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopBuildRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(stopBuildRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new StopBuildResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopBuildResult stopBuildResult = (StopBuildResult)response.getAwsResponse();
            return stopBuildResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateProjectResult updateProject(UpdateProjectRequest updateProjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateProjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateProjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateProjectRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(updateProjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateProjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateProjectResult updateProjectResult = (UpdateProjectResult)response.getAwsResponse();
            return updateProjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

