/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.storagegateway.model.AddWorkingStorageRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class AddWorkingStorageRequestMarshaller
implements Marshaller<Request<AddWorkingStorageRequest>, AddWorkingStorageRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public AddWorkingStorageRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<AddWorkingStorageRequest> marshall(AddWorkingStorageRequest addWorkingStorageRequest) {
        if (addWorkingStorageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AddWorkingStorageRequest> request = new DefaultRequest<AddWorkingStorageRequest>(addWorkingStorageRequest, "AWSStorageGateway");
        request.addHeader("X-Amz-Target", "StorageGateway_20130630.AddWorkingStorage");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList diskIdsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (addWorkingStorageRequest.getGatewayARN() != null) {
                jsonGenerator.writeFieldName("GatewayARN").writeValue(addWorkingStorageRequest.getGatewayARN());
            }
            if (!(diskIdsList = (SdkInternalList)addWorkingStorageRequest.getDiskIds()).isEmpty() || !diskIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("DiskIds");
                jsonGenerator.writeStartArray();
                for (String diskIdsListValue : diskIdsList) {
                    if (diskIdsListValue == null) continue;
                    jsonGenerator.writeValue(diskIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

