/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.xray.AWSXRayAsync;
import com.amazonaws.services.xray.AWSXRayClient;
import com.amazonaws.services.xray.model.BatchGetTracesRequest;
import com.amazonaws.services.xray.model.BatchGetTracesResult;
import com.amazonaws.services.xray.model.GetServiceGraphRequest;
import com.amazonaws.services.xray.model.GetServiceGraphResult;
import com.amazonaws.services.xray.model.GetTraceGraphRequest;
import com.amazonaws.services.xray.model.GetTraceGraphResult;
import com.amazonaws.services.xray.model.GetTraceSummariesRequest;
import com.amazonaws.services.xray.model.GetTraceSummariesResult;
import com.amazonaws.services.xray.model.PutTelemetryRecordsRequest;
import com.amazonaws.services.xray.model.PutTelemetryRecordsResult;
import com.amazonaws.services.xray.model.PutTraceSegmentsRequest;
import com.amazonaws.services.xray.model.PutTraceSegmentsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSXRayAsyncClient
extends AWSXRayClient
implements AWSXRayAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AWSXRayAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    public AWSXRayAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSXRayAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSXRayAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AWSXRayAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSXRayAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSXRayAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSXRayAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AWSXRayAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AWSXRayAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchGetTracesResult> batchGetTracesAsync(BatchGetTracesRequest request) {
        return this.batchGetTracesAsync(request, null);
    }

    @Override
    public Future<BatchGetTracesResult> batchGetTracesAsync(final BatchGetTracesRequest request, final AsyncHandler<BatchGetTracesRequest, BatchGetTracesResult> asyncHandler) {
        return this.executorService.submit(new Callable<BatchGetTracesResult>(){

            @Override
            public BatchGetTracesResult call() throws Exception {
                BatchGetTracesResult result;
                try {
                    result = AWSXRayAsyncClient.this.batchGetTraces(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetServiceGraphResult> getServiceGraphAsync(GetServiceGraphRequest request) {
        return this.getServiceGraphAsync(request, null);
    }

    @Override
    public Future<GetServiceGraphResult> getServiceGraphAsync(final GetServiceGraphRequest request, final AsyncHandler<GetServiceGraphRequest, GetServiceGraphResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetServiceGraphResult>(){

            @Override
            public GetServiceGraphResult call() throws Exception {
                GetServiceGraphResult result;
                try {
                    result = AWSXRayAsyncClient.this.getServiceGraph(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTraceGraphResult> getTraceGraphAsync(GetTraceGraphRequest request) {
        return this.getTraceGraphAsync(request, null);
    }

    @Override
    public Future<GetTraceGraphResult> getTraceGraphAsync(final GetTraceGraphRequest request, final AsyncHandler<GetTraceGraphRequest, GetTraceGraphResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetTraceGraphResult>(){

            @Override
            public GetTraceGraphResult call() throws Exception {
                GetTraceGraphResult result;
                try {
                    result = AWSXRayAsyncClient.this.getTraceGraph(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTraceSummariesResult> getTraceSummariesAsync(GetTraceSummariesRequest request) {
        return this.getTraceSummariesAsync(request, null);
    }

    @Override
    public Future<GetTraceSummariesResult> getTraceSummariesAsync(final GetTraceSummariesRequest request, final AsyncHandler<GetTraceSummariesRequest, GetTraceSummariesResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetTraceSummariesResult>(){

            @Override
            public GetTraceSummariesResult call() throws Exception {
                GetTraceSummariesResult result;
                try {
                    result = AWSXRayAsyncClient.this.getTraceSummaries(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutTelemetryRecordsResult> putTelemetryRecordsAsync(PutTelemetryRecordsRequest request) {
        return this.putTelemetryRecordsAsync(request, null);
    }

    @Override
    public Future<PutTelemetryRecordsResult> putTelemetryRecordsAsync(final PutTelemetryRecordsRequest request, final AsyncHandler<PutTelemetryRecordsRequest, PutTelemetryRecordsResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutTelemetryRecordsResult>(){

            @Override
            public PutTelemetryRecordsResult call() throws Exception {
                PutTelemetryRecordsResult result;
                try {
                    result = AWSXRayAsyncClient.this.putTelemetryRecords(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutTraceSegmentsResult> putTraceSegmentsAsync(PutTraceSegmentsRequest request) {
        return this.putTraceSegmentsAsync(request, null);
    }

    @Override
    public Future<PutTraceSegmentsResult> putTraceSegmentsAsync(final PutTraceSegmentsRequest request, final AsyncHandler<PutTraceSegmentsRequest, PutTraceSegmentsResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutTraceSegmentsResult>(){

            @Override
            public PutTraceSegmentsResult call() throws Exception {
                PutTraceSegmentsResult result;
                try {
                    result = AWSXRayAsyncClient.this.putTraceSegments(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

