/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.DiscoverPollEndpointRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DiscoverPollEndpointRequestMarshaller
implements Marshaller<Request<DiscoverPollEndpointRequest>, DiscoverPollEndpointRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DiscoverPollEndpointRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DiscoverPollEndpointRequest> marshall(DiscoverPollEndpointRequest discoverPollEndpointRequest) {
        if (discoverPollEndpointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DiscoverPollEndpointRequest> request = new DefaultRequest<DiscoverPollEndpointRequest>(discoverPollEndpointRequest, "AmazonECS");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerServiceV20141113.DiscoverPollEndpoint");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (discoverPollEndpointRequest.getContainerInstance() != null) {
                jsonGenerator.writeFieldName("containerInstance").writeValue(discoverPollEndpointRequest.getContainerInstance());
            }
            if (discoverPollEndpointRequest.getCluster() != null) {
                jsonGenerator.writeFieldName("cluster").writeValue(discoverPollEndpointRequest.getCluster());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

