/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.cognitosync.model.DeleteDatasetRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;

public class DeleteDatasetRequestMarshaller
implements Marshaller<Request<DeleteDatasetRequest>, DeleteDatasetRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DeleteDatasetRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteDatasetRequest> marshall(DeleteDatasetRequest deleteDatasetRequest) {
        if (deleteDatasetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteDatasetRequest> request = new DefaultRequest<DeleteDatasetRequest>(deleteDatasetRequest, "AmazonCognitoSync");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "IdentityPoolId", deleteDatasetRequest.getIdentityPoolId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "IdentityId", deleteDatasetRequest.getIdentityId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "DatasetName", deleteDatasetRequest.getDatasetName());
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

