/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.waf_regional.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.waf.model.SizeConstraintSetUpdate;
import com.amazonaws.services.waf.model.UpdateSizeConstraintSetRequest;
import com.amazonaws.services.waf.model.waf_regional.transform.SizeConstraintSetUpdateJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class UpdateSizeConstraintSetRequestMarshaller
implements Marshaller<Request<UpdateSizeConstraintSetRequest>, UpdateSizeConstraintSetRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateSizeConstraintSetRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateSizeConstraintSetRequest> marshall(UpdateSizeConstraintSetRequest updateSizeConstraintSetRequest) {
        if (updateSizeConstraintSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateSizeConstraintSetRequest> request = new DefaultRequest<UpdateSizeConstraintSetRequest>(updateSizeConstraintSetRequest, "AWSWAFRegional");
        request.addHeader("X-Amz-Target", "AWSWAF_Regional_20161128.UpdateSizeConstraintSet");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<SizeConstraintSetUpdate> updatesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateSizeConstraintSetRequest.getSizeConstraintSetId() != null) {
                jsonGenerator.writeFieldName("SizeConstraintSetId").writeValue(updateSizeConstraintSetRequest.getSizeConstraintSetId());
            }
            if (updateSizeConstraintSetRequest.getChangeToken() != null) {
                jsonGenerator.writeFieldName("ChangeToken").writeValue(updateSizeConstraintSetRequest.getChangeToken());
            }
            if ((updatesList = updateSizeConstraintSetRequest.getUpdates()) != null) {
                jsonGenerator.writeFieldName("Updates");
                jsonGenerator.writeStartArray();
                for (SizeConstraintSetUpdate updatesListValue : updatesList) {
                    if (updatesListValue == null) continue;
                    SizeConstraintSetUpdateJsonMarshaller.getInstance().marshall(updatesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

