/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.stepfunctions.model.CreateStateMachineRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateStateMachineRequestMarshaller
implements Marshaller<Request<CreateStateMachineRequest>, CreateStateMachineRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateStateMachineRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateStateMachineRequest> marshall(CreateStateMachineRequest createStateMachineRequest) {
        if (createStateMachineRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateStateMachineRequest> request = new DefaultRequest<CreateStateMachineRequest>(createStateMachineRequest, "AWSStepFunctions");
        request.addHeader("X-Amz-Target", "AWSStepFunctions.CreateStateMachine");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createStateMachineRequest.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(createStateMachineRequest.getName());
            }
            if (createStateMachineRequest.getDefinition() != null) {
                jsonGenerator.writeFieldName("definition").writeValue(createStateMachineRequest.getDefinition());
            }
            if (createStateMachineRequest.getRoleArn() != null) {
                jsonGenerator.writeFieldName("roleArn").writeValue(createStateMachineRequest.getRoleArn());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

