/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.rekognition.model.ComparedFace;
import com.amazonaws.services.rekognition.model.transform.BoundingBoxJsonMarshaller;

public class ComparedFaceJsonMarshaller {
    private static ComparedFaceJsonMarshaller instance;

    public void marshall(ComparedFace comparedFace, StructuredJsonGenerator jsonGenerator) {
        if (comparedFace == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (comparedFace.getBoundingBox() != null) {
                jsonGenerator.writeFieldName("BoundingBox");
                BoundingBoxJsonMarshaller.getInstance().marshall(comparedFace.getBoundingBox(), jsonGenerator);
            }
            if (comparedFace.getConfidence() != null) {
                jsonGenerator.writeFieldName("Confidence").writeValue(comparedFace.getConfidence().floatValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ComparedFaceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ComparedFaceJsonMarshaller();
        }
        return instance;
    }
}

