/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.pinpoint.model.DeleteSegmentRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DeleteSegmentRequestMarshaller
implements Marshaller<Request<DeleteSegmentRequest>, DeleteSegmentRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteSegmentRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteSegmentRequest> marshall(DeleteSegmentRequest deleteSegmentRequest) {
        if (deleteSegmentRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteSegmentRequest> request = new DefaultRequest<DeleteSegmentRequest>(deleteSegmentRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/v1/apps/{application-id}/segments/{segment-id}";
        uriResourcePath = uriResourcePath.replace("{application-id}", deleteSegmentRequest.getApplicationId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteSegmentRequest.getApplicationId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{segment-id}", deleteSegmentRequest.getSegmentId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteSegmentRequest.getSegmentId()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

