/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lightsail.model.GetOperationsForResourceRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class GetOperationsForResourceRequestMarshaller
implements Marshaller<Request<GetOperationsForResourceRequest>, GetOperationsForResourceRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetOperationsForResourceRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetOperationsForResourceRequest> marshall(GetOperationsForResourceRequest getOperationsForResourceRequest) {
        if (getOperationsForResourceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetOperationsForResourceRequest> request = new DefaultRequest<GetOperationsForResourceRequest>(getOperationsForResourceRequest, "AmazonLightsail");
        request.addHeader("X-Amz-Target", "Lightsail_20161128.GetOperationsForResource");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getOperationsForResourceRequest.getResourceName() != null) {
                jsonGenerator.writeFieldName("resourceName").writeValue(getOperationsForResourceRequest.getResourceName());
            }
            if (getOperationsForResourceRequest.getPageToken() != null) {
                jsonGenerator.writeFieldName("pageToken").writeValue(getOperationsForResourceRequest.getPageToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

