/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.batch.model.TerminateJobRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class TerminateJobRequestMarshaller
implements Marshaller<Request<TerminateJobRequest>, TerminateJobRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public TerminateJobRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<TerminateJobRequest> marshall(TerminateJobRequest terminateJobRequest) {
        if (terminateJobRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<TerminateJobRequest> request = new DefaultRequest<TerminateJobRequest>(terminateJobRequest, "AWSBatch");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/v1/terminatejob";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (terminateJobRequest.getJobId() != null) {
                jsonGenerator.writeFieldName("jobId").writeValue(terminateJobRequest.getJobId());
            }
            if (terminateJobRequest.getReason() != null) {
                jsonGenerator.writeFieldName("reason").writeValue(terminateJobRequest.getReason());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

