/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.InventoryItem;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class PutInventoryRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String instanceId;
    private SdkInternalList<InventoryItem> items;

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public PutInventoryRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public List<InventoryItem> getItems() {
        if (this.items == null) {
            this.items = new SdkInternalList();
        }
        return this.items;
    }

    public void setItems(Collection<InventoryItem> items) {
        if (items == null) {
            this.items = null;
            return;
        }
        this.items = new SdkInternalList<InventoryItem>(items);
    }

    public PutInventoryRequest withItems(InventoryItem ... items) {
        if (this.items == null) {
            this.setItems(new SdkInternalList<InventoryItem>(items.length));
        }
        for (InventoryItem ele : items) {
            this.items.add(ele);
        }
        return this;
    }

    public PutInventoryRequest withItems(Collection<InventoryItem> items) {
        this.setItems(items);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: " + this.getInstanceId() + ",");
        }
        if (this.getItems() != null) {
            sb.append("Items: " + this.getItems());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutInventoryRequest)) {
            return false;
        }
        PutInventoryRequest other = (PutInventoryRequest)obj;
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        return other.getItems() == null || other.getItems().equals(this.getItems());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getItems() == null ? 0 : this.getItems().hashCode());
        return hashCode;
    }

    @Override
    public PutInventoryRequest clone() {
        return (PutInventoryRequest)super.clone();
    }
}

