/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.shield.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.shield.model.ListAttacksRequest;
import com.amazonaws.services.shield.model.transform.TimeRangeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class ListAttacksRequestMarshaller
implements Marshaller<Request<ListAttacksRequest>, ListAttacksRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListAttacksRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListAttacksRequest> marshall(ListAttacksRequest listAttacksRequest) {
        if (listAttacksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListAttacksRequest> request = new DefaultRequest<ListAttacksRequest>(listAttacksRequest, "AWSShield");
        request.addHeader("X-Amz-Target", "AWSShield_20160616.ListAttacks");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> resourceArnsList = listAttacksRequest.getResourceArns();
            if (resourceArnsList != null) {
                jsonGenerator.writeFieldName("ResourceArns");
                jsonGenerator.writeStartArray();
                for (String resourceArnsListValue : resourceArnsList) {
                    if (resourceArnsListValue == null) continue;
                    jsonGenerator.writeValue(resourceArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (listAttacksRequest.getStartTime() != null) {
                jsonGenerator.writeFieldName("StartTime");
                TimeRangeJsonMarshaller.getInstance().marshall(listAttacksRequest.getStartTime(), jsonGenerator);
            }
            if (listAttacksRequest.getEndTime() != null) {
                jsonGenerator.writeFieldName("EndTime");
                TimeRangeJsonMarshaller.getInstance().marshall(listAttacksRequest.getEndTime(), jsonGenerator);
            }
            if (listAttacksRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listAttacksRequest.getNextToken());
            }
            if (listAttacksRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(listAttacksRequest.getMaxResults());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

