/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.rekognition.model.DeleteFacesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class DeleteFacesRequestMarshaller
implements Marshaller<Request<DeleteFacesRequest>, DeleteFacesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteFacesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteFacesRequest> marshall(DeleteFacesRequest deleteFacesRequest) {
        if (deleteFacesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteFacesRequest> request = new DefaultRequest<DeleteFacesRequest>(deleteFacesRequest, "AmazonRekognition");
        request.addHeader("X-Amz-Target", "RekognitionService.DeleteFaces");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> faceIdsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (deleteFacesRequest.getCollectionId() != null) {
                jsonGenerator.writeFieldName("CollectionId").writeValue(deleteFacesRequest.getCollectionId());
            }
            if ((faceIdsList = deleteFacesRequest.getFaceIds()) != null) {
                jsonGenerator.writeFieldName("FaceIds");
                jsonGenerator.writeStartArray();
                for (String faceIdsListValue : faceIdsList) {
                    if (faceIdsListValue == null) continue;
                    jsonGenerator.writeValue(faceIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

