/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.pinpoint.model.GetCampaignRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetCampaignRequestMarshaller
implements Marshaller<Request<GetCampaignRequest>, GetCampaignRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetCampaignRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetCampaignRequest> marshall(GetCampaignRequest getCampaignRequest) {
        if (getCampaignRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetCampaignRequest> request = new DefaultRequest<GetCampaignRequest>(getCampaignRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/v1/apps/{application-id}/campaigns/{campaign-id}";
        uriResourcePath = uriResourcePath.replace("{application-id}", getCampaignRequest.getApplicationId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getCampaignRequest.getApplicationId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{campaign-id}", getCampaignRequest.getCampaignId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getCampaignRequest.getCampaignId()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

