/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lightsail.model.CreateDomainEntryRequest;
import com.amazonaws.services.lightsail.model.transform.DomainEntryJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateDomainEntryRequestMarshaller
implements Marshaller<Request<CreateDomainEntryRequest>, CreateDomainEntryRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateDomainEntryRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateDomainEntryRequest> marshall(CreateDomainEntryRequest createDomainEntryRequest) {
        if (createDomainEntryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateDomainEntryRequest> request = new DefaultRequest<CreateDomainEntryRequest>(createDomainEntryRequest, "AmazonLightsail");
        request.addHeader("X-Amz-Target", "Lightsail_20161128.CreateDomainEntry");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createDomainEntryRequest.getDomainName() != null) {
                jsonGenerator.writeFieldName("domainName").writeValue(createDomainEntryRequest.getDomainName());
            }
            if (createDomainEntryRequest.getDomainEntry() != null) {
                jsonGenerator.writeFieldName("domainEntry");
                DomainEntryJsonMarshaller.getInstance().marshall(createDomainEntryRequest.getDomainEntry(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

