/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codebuild.model.EnvironmentVariable;
import com.amazonaws.services.codebuild.model.StartBuildRequest;
import com.amazonaws.services.codebuild.model.transform.EnvironmentVariableJsonMarshaller;
import com.amazonaws.services.codebuild.model.transform.ProjectArtifactsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class StartBuildRequestMarshaller
implements Marshaller<Request<StartBuildRequest>, StartBuildRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public StartBuildRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<StartBuildRequest> marshall(StartBuildRequest startBuildRequest) {
        if (startBuildRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<StartBuildRequest> request = new DefaultRequest<StartBuildRequest>(startBuildRequest, "AWSCodeBuild");
        request.addHeader("X-Amz-Target", "CodeBuild_20161006.StartBuild");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<EnvironmentVariable> environmentVariablesOverrideList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (startBuildRequest.getProjectName() != null) {
                jsonGenerator.writeFieldName("projectName").writeValue(startBuildRequest.getProjectName());
            }
            if (startBuildRequest.getSourceVersion() != null) {
                jsonGenerator.writeFieldName("sourceVersion").writeValue(startBuildRequest.getSourceVersion());
            }
            if (startBuildRequest.getArtifactsOverride() != null) {
                jsonGenerator.writeFieldName("artifactsOverride");
                ProjectArtifactsJsonMarshaller.getInstance().marshall(startBuildRequest.getArtifactsOverride(), jsonGenerator);
            }
            if ((environmentVariablesOverrideList = startBuildRequest.getEnvironmentVariablesOverride()) != null) {
                jsonGenerator.writeFieldName("environmentVariablesOverride");
                jsonGenerator.writeStartArray();
                for (EnvironmentVariable environmentVariablesOverrideListValue : environmentVariablesOverrideList) {
                    if (environmentVariablesOverrideListValue == null) continue;
                    EnvironmentVariableJsonMarshaller.getInstance().marshall(environmentVariablesOverrideListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (startBuildRequest.getBuildspecOverride() != null) {
                jsonGenerator.writeFieldName("buildspecOverride").writeValue(startBuildRequest.getBuildspecOverride());
            }
            if (startBuildRequest.getTimeoutInMinutesOverride() != null) {
                jsonGenerator.writeFieldName("timeoutInMinutesOverride").writeValue(startBuildRequest.getTimeoutInMinutesOverride());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

