/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.DeleteMethodResponseRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DeleteMethodResponseRequestMarshaller
implements Marshaller<Request<DeleteMethodResponseRequest>, DeleteMethodResponseRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteMethodResponseRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteMethodResponseRequest> marshall(DeleteMethodResponseRequest deleteMethodResponseRequest) {
        if (deleteMethodResponseRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteMethodResponseRequest> request = new DefaultRequest<DeleteMethodResponseRequest>(deleteMethodResponseRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/responses/{status_code}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", deleteMethodResponseRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteMethodResponseRequest.getRestApiId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{resource_id}", deleteMethodResponseRequest.getResourceId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteMethodResponseRequest.getResourceId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{http_method}", deleteMethodResponseRequest.getHttpMethod() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteMethodResponseRequest.getHttpMethod()), false) : "");
        uriResourcePath = uriResourcePath.replace("{status_code}", deleteMethodResponseRequest.getStatusCode() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteMethodResponseRequest.getStatusCode()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

