/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.retry;

import com.amazonaws.AmazonServiceException;
import java.util.HashSet;
import java.util.Set;

public class RetryUtils {
    static final Set<String> THROTTLING_ERROR_CODES = new HashSet<String>(9);
    static final Set<String> CLOCK_SKEW_ERROR_CODES = new HashSet<String>(6);
    static final Set<Integer> RETRYABLE_STATUS_CODES = new HashSet<Integer>(4);

    public static boolean isRetryableServiceException(AmazonServiceException ase) {
        if (ase == null) {
            return false;
        }
        int statusCode = ase.getStatusCode();
        return RETRYABLE_STATUS_CODES.contains(statusCode);
    }

    public static boolean isThrottlingException(AmazonServiceException ase) {
        if (ase == null) {
            return false;
        }
        return THROTTLING_ERROR_CODES.contains(ase.getErrorCode());
    }

    public static boolean isRequestEntityTooLargeException(AmazonServiceException ase) {
        return ase != null && ase.getStatusCode() == 413;
    }

    public static boolean isClockSkewError(AmazonServiceException ase) {
        if (ase == null) {
            return false;
        }
        return CLOCK_SKEW_ERROR_CODES.contains(ase.getErrorCode());
    }

    static {
        THROTTLING_ERROR_CODES.add("Throttling");
        THROTTLING_ERROR_CODES.add("ThrottlingException");
        THROTTLING_ERROR_CODES.add("ProvisionedThroughputExceededException");
        THROTTLING_ERROR_CODES.add("SlowDown");
        THROTTLING_ERROR_CODES.add("TooManyRequestsException");
        THROTTLING_ERROR_CODES.add("RequestLimitExceeded");
        THROTTLING_ERROR_CODES.add("BandwidthLimitExceeded");
        THROTTLING_ERROR_CODES.add("RequestThrottled");
        CLOCK_SKEW_ERROR_CODES.add("RequestTimeTooSkewed");
        CLOCK_SKEW_ERROR_CODES.add("RequestExpired");
        CLOCK_SKEW_ERROR_CODES.add("InvalidSignatureException");
        CLOCK_SKEW_ERROR_CODES.add("SignatureDoesNotMatch");
        CLOCK_SKEW_ERROR_CODES.add("AuthFailure");
        CLOCK_SKEW_ERROR_CODES.add("RequestInTheFuture");
        RETRYABLE_STATUS_CODES.add(500);
        RETRYABLE_STATUS_CODES.add(502);
        RETRYABLE_STATUS_CODES.add(503);
        RETRYABLE_STATUS_CODES.add(504);
    }
}

