/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.storagegateway.model.ActivateGatewayRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ActivateGatewayRequestMarshaller
implements Marshaller<Request<ActivateGatewayRequest>, ActivateGatewayRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ActivateGatewayRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ActivateGatewayRequest> marshall(ActivateGatewayRequest activateGatewayRequest) {
        if (activateGatewayRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ActivateGatewayRequest> request = new DefaultRequest<ActivateGatewayRequest>(activateGatewayRequest, "AWSStorageGateway");
        request.addHeader("X-Amz-Target", "StorageGateway_20130630.ActivateGateway");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (activateGatewayRequest.getActivationKey() != null) {
                jsonGenerator.writeFieldName("ActivationKey").writeValue(activateGatewayRequest.getActivationKey());
            }
            if (activateGatewayRequest.getGatewayName() != null) {
                jsonGenerator.writeFieldName("GatewayName").writeValue(activateGatewayRequest.getGatewayName());
            }
            if (activateGatewayRequest.getGatewayTimezone() != null) {
                jsonGenerator.writeFieldName("GatewayTimezone").writeValue(activateGatewayRequest.getGatewayTimezone());
            }
            if (activateGatewayRequest.getGatewayRegion() != null) {
                jsonGenerator.writeFieldName("GatewayRegion").writeValue(activateGatewayRequest.getGatewayRegion());
            }
            if (activateGatewayRequest.getGatewayType() != null) {
                jsonGenerator.writeFieldName("GatewayType").writeValue(activateGatewayRequest.getGatewayType());
            }
            if (activateGatewayRequest.getTapeDriveType() != null) {
                jsonGenerator.writeFieldName("TapeDriveType").writeValue(activateGatewayRequest.getTapeDriveType());
            }
            if (activateGatewayRequest.getMediumChangerType() != null) {
                jsonGenerator.writeFieldName("MediumChangerType").writeValue(activateGatewayRequest.getMediumChangerType());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

