/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.servicecatalog.model.CreateProductRequest;
import com.amazonaws.services.servicecatalog.model.Tag;
import com.amazonaws.services.servicecatalog.model.transform.ProvisioningArtifactPropertiesJsonMarshaller;
import com.amazonaws.services.servicecatalog.model.transform.TagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import java.io.ByteArrayInputStream;
import java.util.List;

public class CreateProductRequestMarshaller
implements Marshaller<Request<CreateProductRequest>, CreateProductRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateProductRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateProductRequest> marshall(CreateProductRequest createProductRequest) {
        if (createProductRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateProductRequest> request = new DefaultRequest<CreateProductRequest>(createProductRequest, "AWSServiceCatalog");
        request.addHeader("X-Amz-Target", "AWS242ServiceCatalogService.CreateProduct");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<Tag> tagsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createProductRequest.getAcceptLanguage() != null) {
                jsonGenerator.writeFieldName("AcceptLanguage").writeValue(createProductRequest.getAcceptLanguage());
            }
            if (createProductRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(createProductRequest.getName());
            }
            if (createProductRequest.getOwner() != null) {
                jsonGenerator.writeFieldName("Owner").writeValue(createProductRequest.getOwner());
            }
            if (createProductRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(createProductRequest.getDescription());
            }
            if (createProductRequest.getDistributor() != null) {
                jsonGenerator.writeFieldName("Distributor").writeValue(createProductRequest.getDistributor());
            }
            if (createProductRequest.getSupportDescription() != null) {
                jsonGenerator.writeFieldName("SupportDescription").writeValue(createProductRequest.getSupportDescription());
            }
            if (createProductRequest.getSupportEmail() != null) {
                jsonGenerator.writeFieldName("SupportEmail").writeValue(createProductRequest.getSupportEmail());
            }
            if (createProductRequest.getSupportUrl() != null) {
                jsonGenerator.writeFieldName("SupportUrl").writeValue(createProductRequest.getSupportUrl());
            }
            if (createProductRequest.getProductType() != null) {
                jsonGenerator.writeFieldName("ProductType").writeValue(createProductRequest.getProductType());
            }
            if ((tagsList = createProductRequest.getTags()) != null) {
                jsonGenerator.writeFieldName("Tags");
                jsonGenerator.writeStartArray();
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (createProductRequest.getProvisioningArtifactParameters() != null) {
                jsonGenerator.writeFieldName("ProvisioningArtifactParameters");
                ProvisioningArtifactPropertiesJsonMarshaller.getInstance().marshall(createProductRequest.getProvisioningArtifactParameters(), jsonGenerator);
            }
            jsonGenerator.writeFieldName("IdempotencyToken").writeValue(IdempotentUtils.resolveString(createProductRequest.getIdempotencyToken()));
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

