/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.servicecatalog.model.CreatePortfolioRequest;
import com.amazonaws.services.servicecatalog.model.Tag;
import com.amazonaws.services.servicecatalog.model.transform.TagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import java.io.ByteArrayInputStream;
import java.util.List;

public class CreatePortfolioRequestMarshaller
implements Marshaller<Request<CreatePortfolioRequest>, CreatePortfolioRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreatePortfolioRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreatePortfolioRequest> marshall(CreatePortfolioRequest createPortfolioRequest) {
        if (createPortfolioRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreatePortfolioRequest> request = new DefaultRequest<CreatePortfolioRequest>(createPortfolioRequest, "AWSServiceCatalog");
        request.addHeader("X-Amz-Target", "AWS242ServiceCatalogService.CreatePortfolio");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<Tag> tagsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createPortfolioRequest.getAcceptLanguage() != null) {
                jsonGenerator.writeFieldName("AcceptLanguage").writeValue(createPortfolioRequest.getAcceptLanguage());
            }
            if (createPortfolioRequest.getDisplayName() != null) {
                jsonGenerator.writeFieldName("DisplayName").writeValue(createPortfolioRequest.getDisplayName());
            }
            if (createPortfolioRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(createPortfolioRequest.getDescription());
            }
            if (createPortfolioRequest.getProviderName() != null) {
                jsonGenerator.writeFieldName("ProviderName").writeValue(createPortfolioRequest.getProviderName());
            }
            if ((tagsList = createPortfolioRequest.getTags()) != null) {
                jsonGenerator.writeFieldName("Tags");
                jsonGenerator.writeStartArray();
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeFieldName("IdempotencyToken").writeValue(IdempotentUtils.resolveString(createPortfolioRequest.getIdempotencyToken()));
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

