/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.logs.model.DescribeLogStreamsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeLogStreamsRequestMarshaller
implements Marshaller<Request<DescribeLogStreamsRequest>, DescribeLogStreamsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeLogStreamsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeLogStreamsRequest> marshall(DescribeLogStreamsRequest describeLogStreamsRequest) {
        if (describeLogStreamsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeLogStreamsRequest> request = new DefaultRequest<DescribeLogStreamsRequest>(describeLogStreamsRequest, "AWSLogs");
        request.addHeader("X-Amz-Target", "Logs_20140328.DescribeLogStreams");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeLogStreamsRequest.getLogGroupName() != null) {
                jsonGenerator.writeFieldName("logGroupName").writeValue(describeLogStreamsRequest.getLogGroupName());
            }
            if (describeLogStreamsRequest.getLogStreamNamePrefix() != null) {
                jsonGenerator.writeFieldName("logStreamNamePrefix").writeValue(describeLogStreamsRequest.getLogStreamNamePrefix());
            }
            if (describeLogStreamsRequest.getOrderBy() != null) {
                jsonGenerator.writeFieldName("orderBy").writeValue(describeLogStreamsRequest.getOrderBy());
            }
            if (describeLogStreamsRequest.getDescending() != null) {
                jsonGenerator.writeFieldName("descending").writeValue(describeLogStreamsRequest.getDescending());
            }
            if (describeLogStreamsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(describeLogStreamsRequest.getNextToken());
            }
            if (describeLogStreamsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("limit").writeValue(describeLogStreamsRequest.getLimit());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

