/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticmapreduce.model.RemoveAutoScalingPolicyRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class RemoveAutoScalingPolicyRequestMarshaller
implements Marshaller<Request<RemoveAutoScalingPolicyRequest>, RemoveAutoScalingPolicyRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public RemoveAutoScalingPolicyRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<RemoveAutoScalingPolicyRequest> marshall(RemoveAutoScalingPolicyRequest removeAutoScalingPolicyRequest) {
        if (removeAutoScalingPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RemoveAutoScalingPolicyRequest> request = new DefaultRequest<RemoveAutoScalingPolicyRequest>(removeAutoScalingPolicyRequest, "AmazonElasticMapReduce");
        request.addHeader("X-Amz-Target", "ElasticMapReduce.RemoveAutoScalingPolicy");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (removeAutoScalingPolicyRequest.getClusterId() != null) {
                jsonGenerator.writeFieldName("ClusterId").writeValue(removeAutoScalingPolicyRequest.getClusterId());
            }
            if (removeAutoScalingPolicyRequest.getInstanceGroupId() != null) {
                jsonGenerator.writeFieldName("InstanceGroupId").writeValue(removeAutoScalingPolicyRequest.getInstanceGroupId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

