/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.config.model.DescribeDeliveryChannelsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeDeliveryChannelsRequestMarshaller
implements Marshaller<Request<DescribeDeliveryChannelsRequest>, DescribeDeliveryChannelsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeDeliveryChannelsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeDeliveryChannelsRequest> marshall(DescribeDeliveryChannelsRequest describeDeliveryChannelsRequest) {
        if (describeDeliveryChannelsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeDeliveryChannelsRequest> request = new DefaultRequest<DescribeDeliveryChannelsRequest>(describeDeliveryChannelsRequest, "AmazonConfig");
        request.addHeader("X-Amz-Target", "StarlingDoveService.DescribeDeliveryChannels");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList deliveryChannelNamesList = (SdkInternalList)describeDeliveryChannelsRequest.getDeliveryChannelNames();
            if (!deliveryChannelNamesList.isEmpty() || !deliveryChannelNamesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("DeliveryChannelNames");
                jsonGenerator.writeStartArray();
                for (String deliveryChannelNamesListValue : deliveryChannelNamesList) {
                    if (deliveryChannelNamesListValue == null) continue;
                    jsonGenerator.writeValue(deliveryChannelNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

