/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.dynamodbv2.model.Record;
import com.amazonaws.services.dynamodbv2.model.transform.StreamRecordJsonMarshaller;

public class RecordJsonMarshaller {
    private static RecordJsonMarshaller instance;

    public void marshall(Record record, StructuredJsonGenerator jsonGenerator) {
        if (record == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (record.getEventID() != null) {
                jsonGenerator.writeFieldName("eventID").writeValue(record.getEventID());
            }
            if (record.getEventName() != null) {
                jsonGenerator.writeFieldName("eventName").writeValue(record.getEventName());
            }
            if (record.getEventVersion() != null) {
                jsonGenerator.writeFieldName("eventVersion").writeValue(record.getEventVersion());
            }
            if (record.getEventSource() != null) {
                jsonGenerator.writeFieldName("eventSource").writeValue(record.getEventSource());
            }
            if (record.getAwsRegion() != null) {
                jsonGenerator.writeFieldName("awsRegion").writeValue(record.getAwsRegion());
            }
            if (record.getDynamodb() != null) {
                jsonGenerator.writeFieldName("dynamodb");
                StreamRecordJsonMarshaller.getInstance().marshall(record.getDynamodb(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RecordJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RecordJsonMarshaller();
        }
        return instance;
    }
}

