/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.servicecatalog.model.UpdateProvisionedProductRequest;
import com.amazonaws.services.servicecatalog.model.UpdateProvisioningParameter;
import com.amazonaws.services.servicecatalog.model.transform.UpdateProvisioningParameterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import java.io.ByteArrayInputStream;
import java.util.List;

public class UpdateProvisionedProductRequestMarshaller
implements Marshaller<Request<UpdateProvisionedProductRequest>, UpdateProvisionedProductRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateProvisionedProductRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateProvisionedProductRequest> marshall(UpdateProvisionedProductRequest updateProvisionedProductRequest) {
        if (updateProvisionedProductRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateProvisionedProductRequest> request = new DefaultRequest<UpdateProvisionedProductRequest>(updateProvisionedProductRequest, "AWSServiceCatalog");
        request.addHeader("X-Amz-Target", "AWS242ServiceCatalogService.UpdateProvisionedProduct");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<UpdateProvisioningParameter> provisioningParametersList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateProvisionedProductRequest.getAcceptLanguage() != null) {
                jsonGenerator.writeFieldName("AcceptLanguage").writeValue(updateProvisionedProductRequest.getAcceptLanguage());
            }
            if (updateProvisionedProductRequest.getProvisionedProductName() != null) {
                jsonGenerator.writeFieldName("ProvisionedProductName").writeValue(updateProvisionedProductRequest.getProvisionedProductName());
            }
            if (updateProvisionedProductRequest.getProvisionedProductId() != null) {
                jsonGenerator.writeFieldName("ProvisionedProductId").writeValue(updateProvisionedProductRequest.getProvisionedProductId());
            }
            if (updateProvisionedProductRequest.getProductId() != null) {
                jsonGenerator.writeFieldName("ProductId").writeValue(updateProvisionedProductRequest.getProductId());
            }
            if (updateProvisionedProductRequest.getProvisioningArtifactId() != null) {
                jsonGenerator.writeFieldName("ProvisioningArtifactId").writeValue(updateProvisionedProductRequest.getProvisioningArtifactId());
            }
            if (updateProvisionedProductRequest.getPathId() != null) {
                jsonGenerator.writeFieldName("PathId").writeValue(updateProvisionedProductRequest.getPathId());
            }
            if ((provisioningParametersList = updateProvisionedProductRequest.getProvisioningParameters()) != null) {
                jsonGenerator.writeFieldName("ProvisioningParameters");
                jsonGenerator.writeStartArray();
                for (UpdateProvisioningParameter provisioningParametersListValue : provisioningParametersList) {
                    if (provisioningParametersListValue == null) continue;
                    UpdateProvisioningParameterJsonMarshaller.getInstance().marshall(provisioningParametersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeFieldName("UpdateToken").writeValue(IdempotentUtils.resolveString(updateProvisionedProductRequest.getUpdateToken()));
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

