/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.ListResourceRecordSetsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;

public class ListResourceRecordSetsRequestMarshaller
implements Marshaller<Request<ListResourceRecordSetsRequest>, ListResourceRecordSetsRequest> {
    @Override
    public Request<ListResourceRecordSetsRequest> marshall(ListResourceRecordSetsRequest listResourceRecordSetsRequest) {
        if (listResourceRecordSetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListResourceRecordSetsRequest> request = new DefaultRequest<ListResourceRecordSetsRequest>(listResourceRecordSetsRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/hostedzone/{Id}/rrset";
        uriResourcePath = uriResourcePath.replace("{Id}", listResourceRecordSetsRequest.getHostedZoneId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(listResourceRecordSetsRequest.getHostedZoneId()), false) : "");
        request.setResourcePath(uriResourcePath);
        if (listResourceRecordSetsRequest.getStartRecordName() != null) {
            request.addParameter("name", StringUtils.fromString(listResourceRecordSetsRequest.getStartRecordName()));
        }
        if (listResourceRecordSetsRequest.getStartRecordType() != null) {
            request.addParameter("type", StringUtils.fromString(listResourceRecordSetsRequest.getStartRecordType()));
        }
        if (listResourceRecordSetsRequest.getStartRecordIdentifier() != null) {
            request.addParameter("identifier", StringUtils.fromString(listResourceRecordSetsRequest.getStartRecordIdentifier()));
        }
        if (listResourceRecordSetsRequest.getMaxItems() != null) {
            request.addParameter("maxitems", StringUtils.fromString(listResourceRecordSetsRequest.getMaxItems()));
        }
        return request;
    }
}

