/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.inspector.AmazonInspectorAsync;
import com.amazonaws.services.inspector.AmazonInspectorClient;
import com.amazonaws.services.inspector.model.AddAttributesToFindingsRequest;
import com.amazonaws.services.inspector.model.AddAttributesToFindingsResult;
import com.amazonaws.services.inspector.model.CreateAssessmentTargetRequest;
import com.amazonaws.services.inspector.model.CreateAssessmentTargetResult;
import com.amazonaws.services.inspector.model.CreateAssessmentTemplateRequest;
import com.amazonaws.services.inspector.model.CreateAssessmentTemplateResult;
import com.amazonaws.services.inspector.model.CreateResourceGroupRequest;
import com.amazonaws.services.inspector.model.CreateResourceGroupResult;
import com.amazonaws.services.inspector.model.DeleteAssessmentRunRequest;
import com.amazonaws.services.inspector.model.DeleteAssessmentRunResult;
import com.amazonaws.services.inspector.model.DeleteAssessmentTargetRequest;
import com.amazonaws.services.inspector.model.DeleteAssessmentTargetResult;
import com.amazonaws.services.inspector.model.DeleteAssessmentTemplateRequest;
import com.amazonaws.services.inspector.model.DeleteAssessmentTemplateResult;
import com.amazonaws.services.inspector.model.DescribeAssessmentRunsRequest;
import com.amazonaws.services.inspector.model.DescribeAssessmentRunsResult;
import com.amazonaws.services.inspector.model.DescribeAssessmentTargetsRequest;
import com.amazonaws.services.inspector.model.DescribeAssessmentTargetsResult;
import com.amazonaws.services.inspector.model.DescribeAssessmentTemplatesRequest;
import com.amazonaws.services.inspector.model.DescribeAssessmentTemplatesResult;
import com.amazonaws.services.inspector.model.DescribeCrossAccountAccessRoleRequest;
import com.amazonaws.services.inspector.model.DescribeCrossAccountAccessRoleResult;
import com.amazonaws.services.inspector.model.DescribeFindingsRequest;
import com.amazonaws.services.inspector.model.DescribeFindingsResult;
import com.amazonaws.services.inspector.model.DescribeResourceGroupsRequest;
import com.amazonaws.services.inspector.model.DescribeResourceGroupsResult;
import com.amazonaws.services.inspector.model.DescribeRulesPackagesRequest;
import com.amazonaws.services.inspector.model.DescribeRulesPackagesResult;
import com.amazonaws.services.inspector.model.GetTelemetryMetadataRequest;
import com.amazonaws.services.inspector.model.GetTelemetryMetadataResult;
import com.amazonaws.services.inspector.model.ListAssessmentRunAgentsRequest;
import com.amazonaws.services.inspector.model.ListAssessmentRunAgentsResult;
import com.amazonaws.services.inspector.model.ListAssessmentRunsRequest;
import com.amazonaws.services.inspector.model.ListAssessmentRunsResult;
import com.amazonaws.services.inspector.model.ListAssessmentTargetsRequest;
import com.amazonaws.services.inspector.model.ListAssessmentTargetsResult;
import com.amazonaws.services.inspector.model.ListAssessmentTemplatesRequest;
import com.amazonaws.services.inspector.model.ListAssessmentTemplatesResult;
import com.amazonaws.services.inspector.model.ListEventSubscriptionsRequest;
import com.amazonaws.services.inspector.model.ListEventSubscriptionsResult;
import com.amazonaws.services.inspector.model.ListFindingsRequest;
import com.amazonaws.services.inspector.model.ListFindingsResult;
import com.amazonaws.services.inspector.model.ListRulesPackagesRequest;
import com.amazonaws.services.inspector.model.ListRulesPackagesResult;
import com.amazonaws.services.inspector.model.ListTagsForResourceRequest;
import com.amazonaws.services.inspector.model.ListTagsForResourceResult;
import com.amazonaws.services.inspector.model.PreviewAgentsRequest;
import com.amazonaws.services.inspector.model.PreviewAgentsResult;
import com.amazonaws.services.inspector.model.RegisterCrossAccountAccessRoleRequest;
import com.amazonaws.services.inspector.model.RegisterCrossAccountAccessRoleResult;
import com.amazonaws.services.inspector.model.RemoveAttributesFromFindingsRequest;
import com.amazonaws.services.inspector.model.RemoveAttributesFromFindingsResult;
import com.amazonaws.services.inspector.model.SetTagsForResourceRequest;
import com.amazonaws.services.inspector.model.SetTagsForResourceResult;
import com.amazonaws.services.inspector.model.StartAssessmentRunRequest;
import com.amazonaws.services.inspector.model.StartAssessmentRunResult;
import com.amazonaws.services.inspector.model.StopAssessmentRunRequest;
import com.amazonaws.services.inspector.model.StopAssessmentRunResult;
import com.amazonaws.services.inspector.model.SubscribeToEventRequest;
import com.amazonaws.services.inspector.model.SubscribeToEventResult;
import com.amazonaws.services.inspector.model.UnsubscribeFromEventRequest;
import com.amazonaws.services.inspector.model.UnsubscribeFromEventResult;
import com.amazonaws.services.inspector.model.UpdateAssessmentTargetRequest;
import com.amazonaws.services.inspector.model.UpdateAssessmentTargetResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonInspectorAsyncClient
extends AmazonInspectorClient
implements AmazonInspectorAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonInspectorAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    public AmazonInspectorAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonInspectorAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonInspectorAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AmazonInspectorAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonInspectorAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonInspectorAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonInspectorAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AmazonInspectorAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AmazonInspectorAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddAttributesToFindingsResult> addAttributesToFindingsAsync(AddAttributesToFindingsRequest request) {
        return this.addAttributesToFindingsAsync(request, null);
    }

    @Override
    public Future<AddAttributesToFindingsResult> addAttributesToFindingsAsync(final AddAttributesToFindingsRequest request, final AsyncHandler<AddAttributesToFindingsRequest, AddAttributesToFindingsResult> asyncHandler) {
        return this.executorService.submit(new Callable<AddAttributesToFindingsResult>(){

            @Override
            public AddAttributesToFindingsResult call() throws Exception {
                AddAttributesToFindingsResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.addAttributesToFindings(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateAssessmentTargetResult> createAssessmentTargetAsync(CreateAssessmentTargetRequest request) {
        return this.createAssessmentTargetAsync(request, null);
    }

    @Override
    public Future<CreateAssessmentTargetResult> createAssessmentTargetAsync(final CreateAssessmentTargetRequest request, final AsyncHandler<CreateAssessmentTargetRequest, CreateAssessmentTargetResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateAssessmentTargetResult>(){

            @Override
            public CreateAssessmentTargetResult call() throws Exception {
                CreateAssessmentTargetResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.createAssessmentTarget(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateAssessmentTemplateResult> createAssessmentTemplateAsync(CreateAssessmentTemplateRequest request) {
        return this.createAssessmentTemplateAsync(request, null);
    }

    @Override
    public Future<CreateAssessmentTemplateResult> createAssessmentTemplateAsync(final CreateAssessmentTemplateRequest request, final AsyncHandler<CreateAssessmentTemplateRequest, CreateAssessmentTemplateResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateAssessmentTemplateResult>(){

            @Override
            public CreateAssessmentTemplateResult call() throws Exception {
                CreateAssessmentTemplateResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.createAssessmentTemplate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateResourceGroupResult> createResourceGroupAsync(CreateResourceGroupRequest request) {
        return this.createResourceGroupAsync(request, null);
    }

    @Override
    public Future<CreateResourceGroupResult> createResourceGroupAsync(final CreateResourceGroupRequest request, final AsyncHandler<CreateResourceGroupRequest, CreateResourceGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateResourceGroupResult>(){

            @Override
            public CreateResourceGroupResult call() throws Exception {
                CreateResourceGroupResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.createResourceGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAssessmentRunResult> deleteAssessmentRunAsync(DeleteAssessmentRunRequest request) {
        return this.deleteAssessmentRunAsync(request, null);
    }

    @Override
    public Future<DeleteAssessmentRunResult> deleteAssessmentRunAsync(final DeleteAssessmentRunRequest request, final AsyncHandler<DeleteAssessmentRunRequest, DeleteAssessmentRunResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteAssessmentRunResult>(){

            @Override
            public DeleteAssessmentRunResult call() throws Exception {
                DeleteAssessmentRunResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.deleteAssessmentRun(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAssessmentTargetResult> deleteAssessmentTargetAsync(DeleteAssessmentTargetRequest request) {
        return this.deleteAssessmentTargetAsync(request, null);
    }

    @Override
    public Future<DeleteAssessmentTargetResult> deleteAssessmentTargetAsync(final DeleteAssessmentTargetRequest request, final AsyncHandler<DeleteAssessmentTargetRequest, DeleteAssessmentTargetResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteAssessmentTargetResult>(){

            @Override
            public DeleteAssessmentTargetResult call() throws Exception {
                DeleteAssessmentTargetResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.deleteAssessmentTarget(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAssessmentTemplateResult> deleteAssessmentTemplateAsync(DeleteAssessmentTemplateRequest request) {
        return this.deleteAssessmentTemplateAsync(request, null);
    }

    @Override
    public Future<DeleteAssessmentTemplateResult> deleteAssessmentTemplateAsync(final DeleteAssessmentTemplateRequest request, final AsyncHandler<DeleteAssessmentTemplateRequest, DeleteAssessmentTemplateResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteAssessmentTemplateResult>(){

            @Override
            public DeleteAssessmentTemplateResult call() throws Exception {
                DeleteAssessmentTemplateResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.deleteAssessmentTemplate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAssessmentRunsResult> describeAssessmentRunsAsync(DescribeAssessmentRunsRequest request) {
        return this.describeAssessmentRunsAsync(request, null);
    }

    @Override
    public Future<DescribeAssessmentRunsResult> describeAssessmentRunsAsync(final DescribeAssessmentRunsRequest request, final AsyncHandler<DescribeAssessmentRunsRequest, DescribeAssessmentRunsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeAssessmentRunsResult>(){

            @Override
            public DescribeAssessmentRunsResult call() throws Exception {
                DescribeAssessmentRunsResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.describeAssessmentRuns(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAssessmentTargetsResult> describeAssessmentTargetsAsync(DescribeAssessmentTargetsRequest request) {
        return this.describeAssessmentTargetsAsync(request, null);
    }

    @Override
    public Future<DescribeAssessmentTargetsResult> describeAssessmentTargetsAsync(final DescribeAssessmentTargetsRequest request, final AsyncHandler<DescribeAssessmentTargetsRequest, DescribeAssessmentTargetsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeAssessmentTargetsResult>(){

            @Override
            public DescribeAssessmentTargetsResult call() throws Exception {
                DescribeAssessmentTargetsResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.describeAssessmentTargets(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAssessmentTemplatesResult> describeAssessmentTemplatesAsync(DescribeAssessmentTemplatesRequest request) {
        return this.describeAssessmentTemplatesAsync(request, null);
    }

    @Override
    public Future<DescribeAssessmentTemplatesResult> describeAssessmentTemplatesAsync(final DescribeAssessmentTemplatesRequest request, final AsyncHandler<DescribeAssessmentTemplatesRequest, DescribeAssessmentTemplatesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeAssessmentTemplatesResult>(){

            @Override
            public DescribeAssessmentTemplatesResult call() throws Exception {
                DescribeAssessmentTemplatesResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.describeAssessmentTemplates(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCrossAccountAccessRoleResult> describeCrossAccountAccessRoleAsync(DescribeCrossAccountAccessRoleRequest request) {
        return this.describeCrossAccountAccessRoleAsync(request, null);
    }

    @Override
    public Future<DescribeCrossAccountAccessRoleResult> describeCrossAccountAccessRoleAsync(final DescribeCrossAccountAccessRoleRequest request, final AsyncHandler<DescribeCrossAccountAccessRoleRequest, DescribeCrossAccountAccessRoleResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeCrossAccountAccessRoleResult>(){

            @Override
            public DescribeCrossAccountAccessRoleResult call() throws Exception {
                DescribeCrossAccountAccessRoleResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.describeCrossAccountAccessRole(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFindingsResult> describeFindingsAsync(DescribeFindingsRequest request) {
        return this.describeFindingsAsync(request, null);
    }

    @Override
    public Future<DescribeFindingsResult> describeFindingsAsync(final DescribeFindingsRequest request, final AsyncHandler<DescribeFindingsRequest, DescribeFindingsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeFindingsResult>(){

            @Override
            public DescribeFindingsResult call() throws Exception {
                DescribeFindingsResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.describeFindings(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeResourceGroupsResult> describeResourceGroupsAsync(DescribeResourceGroupsRequest request) {
        return this.describeResourceGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeResourceGroupsResult> describeResourceGroupsAsync(final DescribeResourceGroupsRequest request, final AsyncHandler<DescribeResourceGroupsRequest, DescribeResourceGroupsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeResourceGroupsResult>(){

            @Override
            public DescribeResourceGroupsResult call() throws Exception {
                DescribeResourceGroupsResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.describeResourceGroups(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRulesPackagesResult> describeRulesPackagesAsync(DescribeRulesPackagesRequest request) {
        return this.describeRulesPackagesAsync(request, null);
    }

    @Override
    public Future<DescribeRulesPackagesResult> describeRulesPackagesAsync(final DescribeRulesPackagesRequest request, final AsyncHandler<DescribeRulesPackagesRequest, DescribeRulesPackagesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeRulesPackagesResult>(){

            @Override
            public DescribeRulesPackagesResult call() throws Exception {
                DescribeRulesPackagesResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.describeRulesPackages(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTelemetryMetadataResult> getTelemetryMetadataAsync(GetTelemetryMetadataRequest request) {
        return this.getTelemetryMetadataAsync(request, null);
    }

    @Override
    public Future<GetTelemetryMetadataResult> getTelemetryMetadataAsync(final GetTelemetryMetadataRequest request, final AsyncHandler<GetTelemetryMetadataRequest, GetTelemetryMetadataResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetTelemetryMetadataResult>(){

            @Override
            public GetTelemetryMetadataResult call() throws Exception {
                GetTelemetryMetadataResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.getTelemetryMetadata(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAssessmentRunAgentsResult> listAssessmentRunAgentsAsync(ListAssessmentRunAgentsRequest request) {
        return this.listAssessmentRunAgentsAsync(request, null);
    }

    @Override
    public Future<ListAssessmentRunAgentsResult> listAssessmentRunAgentsAsync(final ListAssessmentRunAgentsRequest request, final AsyncHandler<ListAssessmentRunAgentsRequest, ListAssessmentRunAgentsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListAssessmentRunAgentsResult>(){

            @Override
            public ListAssessmentRunAgentsResult call() throws Exception {
                ListAssessmentRunAgentsResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.listAssessmentRunAgents(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAssessmentRunsResult> listAssessmentRunsAsync(ListAssessmentRunsRequest request) {
        return this.listAssessmentRunsAsync(request, null);
    }

    @Override
    public Future<ListAssessmentRunsResult> listAssessmentRunsAsync(final ListAssessmentRunsRequest request, final AsyncHandler<ListAssessmentRunsRequest, ListAssessmentRunsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListAssessmentRunsResult>(){

            @Override
            public ListAssessmentRunsResult call() throws Exception {
                ListAssessmentRunsResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.listAssessmentRuns(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAssessmentTargetsResult> listAssessmentTargetsAsync(ListAssessmentTargetsRequest request) {
        return this.listAssessmentTargetsAsync(request, null);
    }

    @Override
    public Future<ListAssessmentTargetsResult> listAssessmentTargetsAsync(final ListAssessmentTargetsRequest request, final AsyncHandler<ListAssessmentTargetsRequest, ListAssessmentTargetsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListAssessmentTargetsResult>(){

            @Override
            public ListAssessmentTargetsResult call() throws Exception {
                ListAssessmentTargetsResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.listAssessmentTargets(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAssessmentTemplatesResult> listAssessmentTemplatesAsync(ListAssessmentTemplatesRequest request) {
        return this.listAssessmentTemplatesAsync(request, null);
    }

    @Override
    public Future<ListAssessmentTemplatesResult> listAssessmentTemplatesAsync(final ListAssessmentTemplatesRequest request, final AsyncHandler<ListAssessmentTemplatesRequest, ListAssessmentTemplatesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListAssessmentTemplatesResult>(){

            @Override
            public ListAssessmentTemplatesResult call() throws Exception {
                ListAssessmentTemplatesResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.listAssessmentTemplates(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEventSubscriptionsResult> listEventSubscriptionsAsync(ListEventSubscriptionsRequest request) {
        return this.listEventSubscriptionsAsync(request, null);
    }

    @Override
    public Future<ListEventSubscriptionsResult> listEventSubscriptionsAsync(final ListEventSubscriptionsRequest request, final AsyncHandler<ListEventSubscriptionsRequest, ListEventSubscriptionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListEventSubscriptionsResult>(){

            @Override
            public ListEventSubscriptionsResult call() throws Exception {
                ListEventSubscriptionsResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.listEventSubscriptions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFindingsResult> listFindingsAsync(ListFindingsRequest request) {
        return this.listFindingsAsync(request, null);
    }

    @Override
    public Future<ListFindingsResult> listFindingsAsync(final ListFindingsRequest request, final AsyncHandler<ListFindingsRequest, ListFindingsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListFindingsResult>(){

            @Override
            public ListFindingsResult call() throws Exception {
                ListFindingsResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.listFindings(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRulesPackagesResult> listRulesPackagesAsync(ListRulesPackagesRequest request) {
        return this.listRulesPackagesAsync(request, null);
    }

    @Override
    public Future<ListRulesPackagesResult> listRulesPackagesAsync(final ListRulesPackagesRequest request, final AsyncHandler<ListRulesPackagesRequest, ListRulesPackagesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListRulesPackagesResult>(){

            @Override
            public ListRulesPackagesResult call() throws Exception {
                ListRulesPackagesResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.listRulesPackages(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(final ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.listTagsForResource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PreviewAgentsResult> previewAgentsAsync(PreviewAgentsRequest request) {
        return this.previewAgentsAsync(request, null);
    }

    @Override
    public Future<PreviewAgentsResult> previewAgentsAsync(final PreviewAgentsRequest request, final AsyncHandler<PreviewAgentsRequest, PreviewAgentsResult> asyncHandler) {
        return this.executorService.submit(new Callable<PreviewAgentsResult>(){

            @Override
            public PreviewAgentsResult call() throws Exception {
                PreviewAgentsResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.previewAgents(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RegisterCrossAccountAccessRoleResult> registerCrossAccountAccessRoleAsync(RegisterCrossAccountAccessRoleRequest request) {
        return this.registerCrossAccountAccessRoleAsync(request, null);
    }

    @Override
    public Future<RegisterCrossAccountAccessRoleResult> registerCrossAccountAccessRoleAsync(final RegisterCrossAccountAccessRoleRequest request, final AsyncHandler<RegisterCrossAccountAccessRoleRequest, RegisterCrossAccountAccessRoleResult> asyncHandler) {
        return this.executorService.submit(new Callable<RegisterCrossAccountAccessRoleResult>(){

            @Override
            public RegisterCrossAccountAccessRoleResult call() throws Exception {
                RegisterCrossAccountAccessRoleResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.registerCrossAccountAccessRole(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveAttributesFromFindingsResult> removeAttributesFromFindingsAsync(RemoveAttributesFromFindingsRequest request) {
        return this.removeAttributesFromFindingsAsync(request, null);
    }

    @Override
    public Future<RemoveAttributesFromFindingsResult> removeAttributesFromFindingsAsync(final RemoveAttributesFromFindingsRequest request, final AsyncHandler<RemoveAttributesFromFindingsRequest, RemoveAttributesFromFindingsResult> asyncHandler) {
        return this.executorService.submit(new Callable<RemoveAttributesFromFindingsResult>(){

            @Override
            public RemoveAttributesFromFindingsResult call() throws Exception {
                RemoveAttributesFromFindingsResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.removeAttributesFromFindings(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetTagsForResourceResult> setTagsForResourceAsync(SetTagsForResourceRequest request) {
        return this.setTagsForResourceAsync(request, null);
    }

    @Override
    public Future<SetTagsForResourceResult> setTagsForResourceAsync(final SetTagsForResourceRequest request, final AsyncHandler<SetTagsForResourceRequest, SetTagsForResourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<SetTagsForResourceResult>(){

            @Override
            public SetTagsForResourceResult call() throws Exception {
                SetTagsForResourceResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.setTagsForResource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartAssessmentRunResult> startAssessmentRunAsync(StartAssessmentRunRequest request) {
        return this.startAssessmentRunAsync(request, null);
    }

    @Override
    public Future<StartAssessmentRunResult> startAssessmentRunAsync(final StartAssessmentRunRequest request, final AsyncHandler<StartAssessmentRunRequest, StartAssessmentRunResult> asyncHandler) {
        return this.executorService.submit(new Callable<StartAssessmentRunResult>(){

            @Override
            public StartAssessmentRunResult call() throws Exception {
                StartAssessmentRunResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.startAssessmentRun(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopAssessmentRunResult> stopAssessmentRunAsync(StopAssessmentRunRequest request) {
        return this.stopAssessmentRunAsync(request, null);
    }

    @Override
    public Future<StopAssessmentRunResult> stopAssessmentRunAsync(final StopAssessmentRunRequest request, final AsyncHandler<StopAssessmentRunRequest, StopAssessmentRunResult> asyncHandler) {
        return this.executorService.submit(new Callable<StopAssessmentRunResult>(){

            @Override
            public StopAssessmentRunResult call() throws Exception {
                StopAssessmentRunResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.stopAssessmentRun(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SubscribeToEventResult> subscribeToEventAsync(SubscribeToEventRequest request) {
        return this.subscribeToEventAsync(request, null);
    }

    @Override
    public Future<SubscribeToEventResult> subscribeToEventAsync(final SubscribeToEventRequest request, final AsyncHandler<SubscribeToEventRequest, SubscribeToEventResult> asyncHandler) {
        return this.executorService.submit(new Callable<SubscribeToEventResult>(){

            @Override
            public SubscribeToEventResult call() throws Exception {
                SubscribeToEventResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.subscribeToEvent(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UnsubscribeFromEventResult> unsubscribeFromEventAsync(UnsubscribeFromEventRequest request) {
        return this.unsubscribeFromEventAsync(request, null);
    }

    @Override
    public Future<UnsubscribeFromEventResult> unsubscribeFromEventAsync(final UnsubscribeFromEventRequest request, final AsyncHandler<UnsubscribeFromEventRequest, UnsubscribeFromEventResult> asyncHandler) {
        return this.executorService.submit(new Callable<UnsubscribeFromEventResult>(){

            @Override
            public UnsubscribeFromEventResult call() throws Exception {
                UnsubscribeFromEventResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.unsubscribeFromEvent(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateAssessmentTargetResult> updateAssessmentTargetAsync(UpdateAssessmentTargetRequest request) {
        return this.updateAssessmentTargetAsync(request, null);
    }

    @Override
    public Future<UpdateAssessmentTargetResult> updateAssessmentTargetAsync(final UpdateAssessmentTargetRequest request, final AsyncHandler<UpdateAssessmentTargetRequest, UpdateAssessmentTargetResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateAssessmentTargetResult>(){

            @Override
            public UpdateAssessmentTargetResult call() throws Exception {
                UpdateAssessmentTargetResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.updateAssessmentTarget(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

