/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.PutRequest;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import java.util.Map;

public class PutRequestJsonMarshaller {
    private static PutRequestJsonMarshaller instance;

    public void marshall(PutRequest putRequest, StructuredJsonGenerator jsonGenerator) {
        if (putRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            Map<String, AttributeValue> itemMap = putRequest.getItem();
            if (itemMap != null) {
                jsonGenerator.writeFieldName("Item");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, AttributeValue> itemMapValue : itemMap.entrySet()) {
                    if (itemMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(itemMapValue.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(itemMapValue.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PutRequestJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PutRequestJsonMarshaller();
        }
        return instance;
    }
}

