/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.Export;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListExportsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<Export> exports;
    private String nextToken;

    public List<Export> getExports() {
        if (this.exports == null) {
            this.exports = new SdkInternalList();
        }
        return this.exports;
    }

    public void setExports(Collection<Export> exports) {
        if (exports == null) {
            this.exports = null;
            return;
        }
        this.exports = new SdkInternalList<Export>(exports);
    }

    public ListExportsResult withExports(Export ... exports) {
        if (this.exports == null) {
            this.setExports(new SdkInternalList<Export>(exports.length));
        }
        for (Export ele : exports) {
            this.exports.add(ele);
        }
        return this;
    }

    public ListExportsResult withExports(Collection<Export> exports) {
        this.setExports(exports);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListExportsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getExports() != null) {
            sb.append("Exports: " + this.getExports() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExportsResult)) {
            return false;
        }
        ListExportsResult other = (ListExportsResult)obj;
        if (other.getExports() == null ^ this.getExports() == null) {
            return false;
        }
        if (other.getExports() != null && !other.getExports().equals(this.getExports())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getExports() == null ? 0 : this.getExports().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListExportsResult clone() {
        try {
            return (ListExportsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

