/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.IntegrationResponse;
import java.util.Map;

public class IntegrationResponseJsonMarshaller {
    private static IntegrationResponseJsonMarshaller instance;

    public void marshall(IntegrationResponse integrationResponse, StructuredJsonGenerator jsonGenerator) {
        if (integrationResponse == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, String> responseTemplatesMap;
            Map<String, String> responseParametersMap;
            jsonGenerator.writeStartObject();
            if (integrationResponse.getStatusCode() != null) {
                jsonGenerator.writeFieldName("statusCode").writeValue(integrationResponse.getStatusCode());
            }
            if (integrationResponse.getSelectionPattern() != null) {
                jsonGenerator.writeFieldName("selectionPattern").writeValue(integrationResponse.getSelectionPattern());
            }
            if ((responseParametersMap = integrationResponse.getResponseParameters()) != null) {
                jsonGenerator.writeFieldName("responseParameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> responseParametersMapValue : responseParametersMap.entrySet()) {
                    if (responseParametersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(responseParametersMapValue.getKey());
                    jsonGenerator.writeValue(responseParametersMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if ((responseTemplatesMap = integrationResponse.getResponseTemplates()) != null) {
                jsonGenerator.writeFieldName("responseTemplates");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> responseTemplatesMapValue : responseTemplatesMap.entrySet()) {
                    if (responseTemplatesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(responseTemplatesMapValue.getKey());
                    jsonGenerator.writeValue(responseTemplatesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static IntegrationResponseJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new IntegrationResponseJsonMarshaller();
        }
        return instance;
    }
}

