/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.inspector.model.SetTagsForResourceRequest;
import com.amazonaws.services.inspector.model.Tag;
import com.amazonaws.services.inspector.model.transform.TagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class SetTagsForResourceRequestMarshaller
implements Marshaller<Request<SetTagsForResourceRequest>, SetTagsForResourceRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public SetTagsForResourceRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<SetTagsForResourceRequest> marshall(SetTagsForResourceRequest setTagsForResourceRequest) {
        if (setTagsForResourceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SetTagsForResourceRequest> request = new DefaultRequest<SetTagsForResourceRequest>(setTagsForResourceRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.SetTagsForResource");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<Tag> tagsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (setTagsForResourceRequest.getResourceArn() != null) {
                jsonGenerator.writeFieldName("resourceArn").writeValue(setTagsForResourceRequest.getResourceArn());
            }
            if ((tagsList = setTagsForResourceRequest.getTags()) != null) {
                jsonGenerator.writeFieldName("tags");
                jsonGenerator.writeStartArray();
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

