/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidentity.model.CognitoIdentityProvider;
import com.amazonaws.services.cognitoidentity.model.UpdateIdentityPoolRequest;
import com.amazonaws.services.cognitoidentity.model.transform.CognitoIdentityProviderJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Map;

public class UpdateIdentityPoolRequestMarshaller
implements Marshaller<Request<UpdateIdentityPoolRequest>, UpdateIdentityPoolRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateIdentityPoolRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateIdentityPoolRequest> marshall(UpdateIdentityPoolRequest updateIdentityPoolRequest) {
        if (updateIdentityPoolRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateIdentityPoolRequest> request = new DefaultRequest<UpdateIdentityPoolRequest>(updateIdentityPoolRequest, "AmazonCognitoIdentity");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityService.UpdateIdentityPool");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> list;
            List<CognitoIdentityProvider> cognitoIdentityProvidersList;
            List<String> openIdConnectProviderARNsList;
            Map<String, String> supportedLoginProvidersMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateIdentityPoolRequest.getIdentityPoolId() != null) {
                jsonGenerator.writeFieldName("IdentityPoolId").writeValue(updateIdentityPoolRequest.getIdentityPoolId());
            }
            if (updateIdentityPoolRequest.getIdentityPoolName() != null) {
                jsonGenerator.writeFieldName("IdentityPoolName").writeValue(updateIdentityPoolRequest.getIdentityPoolName());
            }
            if (updateIdentityPoolRequest.getAllowUnauthenticatedIdentities() != null) {
                jsonGenerator.writeFieldName("AllowUnauthenticatedIdentities").writeValue(updateIdentityPoolRequest.getAllowUnauthenticatedIdentities());
            }
            if ((supportedLoginProvidersMap = updateIdentityPoolRequest.getSupportedLoginProviders()) != null) {
                jsonGenerator.writeFieldName("SupportedLoginProviders");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> supportedLoginProvidersMapValue : supportedLoginProvidersMap.entrySet()) {
                    if (supportedLoginProvidersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)supportedLoginProvidersMapValue.getKey());
                    jsonGenerator.writeValue((String)supportedLoginProvidersMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (updateIdentityPoolRequest.getDeveloperProviderName() != null) {
                jsonGenerator.writeFieldName("DeveloperProviderName").writeValue(updateIdentityPoolRequest.getDeveloperProviderName());
            }
            if ((openIdConnectProviderARNsList = updateIdentityPoolRequest.getOpenIdConnectProviderARNs()) != null) {
                jsonGenerator.writeFieldName("OpenIdConnectProviderARNs");
                jsonGenerator.writeStartArray();
                for (String string : openIdConnectProviderARNsList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((cognitoIdentityProvidersList = updateIdentityPoolRequest.getCognitoIdentityProviders()) != null) {
                jsonGenerator.writeFieldName("CognitoIdentityProviders");
                jsonGenerator.writeStartArray();
                for (CognitoIdentityProvider cognitoIdentityProvider : cognitoIdentityProvidersList) {
                    if (cognitoIdentityProvider == null) continue;
                    CognitoIdentityProviderJsonMarshaller.getInstance().marshall(cognitoIdentityProvider, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list = updateIdentityPoolRequest.getSamlProviderARNs()) != null) {
                jsonGenerator.writeFieldName("SamlProviderARNs");
                jsonGenerator.writeStartArray();
                for (String samlProviderARNsListValue : list) {
                    if (samlProviderARNsListValue == null) continue;
                    jsonGenerator.writeValue(samlProviderARNsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] byArray = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(byArray));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

