/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.lambda.model.InvokeAsyncRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;

public class InvokeAsyncRequestMarshaller
implements Marshaller<Request<InvokeAsyncRequest>, InvokeAsyncRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public InvokeAsyncRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<InvokeAsyncRequest> marshall(InvokeAsyncRequest invokeAsyncRequest) {
        if (invokeAsyncRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<InvokeAsyncRequest> request = new DefaultRequest<InvokeAsyncRequest>(invokeAsyncRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2014-11-13/functions/{FunctionName}/invoke-async/";
        uriResourcePath = uriResourcePath.replace("{FunctionName}", invokeAsyncRequest.getFunctionName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(invokeAsyncRequest.getFunctionName()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(invokeAsyncRequest.getInvokeArgs());
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

